/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.reference;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.temporal.object.DefaultTemporalCoordinate;
import org.geotoolkit.temporal.reference.DefaultTemporalReferenceSystem;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalCoordinateSystem;
import org.opengis.temporal.TemporalReferenceSystem;

@XmlType(name="TimeCoordinateSystem_Type", propOrder={"origin", "interval"})
@XmlRootElement(name="TimeCoordinateSystem")
public class DefaultTemporalCoordinateSystem
extends DefaultTemporalReferenceSystem
implements TemporalCoordinateSystem {
    private static Unit<Time> UNIT_MS = Units.SECOND.divide(1000.0);
    private Date origin;
    private Unit<Time> interval;
    private UnitConverter unitToMS = null;
    private UnitConverter msToUnit = null;

    public DefaultTemporalCoordinateSystem(Map<String, ?> properties, Unit<Time> interval, Date origin) {
        super(properties);
        this.origin = origin;
        ArgumentChecks.ensureNonNull((String)"interval", interval);
        this.interval = interval;
    }

    public DefaultTemporalCoordinateSystem(TemporalCoordinateSystem object) {
        super((TemporalReferenceSystem)object);
        if (object != null) {
            this.origin = object.getOrigin();
            Unit inter = object.getInterval();
            ArgumentChecks.ensureNonNull((String)"interval", (Object)inter);
            this.interval = inter;
        }
    }

    public static DefaultTemporalCoordinateSystem castOrCopy(TemporalCoordinateSystem object) {
        if (object == null || object instanceof DefaultTemporalCoordinateSystem) {
            return (DefaultTemporalCoordinateSystem)object;
        }
        return new DefaultTemporalCoordinateSystem(object);
    }

    @XmlElement(name="originPosition", required=true)
    public Date getOrigin() {
        return this.origin;
    }

    public Unit<Time> getInterval() {
        return this.interval;
    }

    @XmlElement(name="interval", required=true)
    private Interval getinterval() {
        return new Interval(this.interval);
    }

    public Date transformCoord(TemporalCoordinate c_value) {
        DefaultTemporalCoordinate value;
        if (this.unitToMS == null) {
            this.unitToMS = this.interval.getConverterTo(UNIT_MS);
        }
        if ((value = (DefaultTemporalCoordinate)c_value).getFrame() != null && value.getFrame() instanceof TemporalCoordinateSystem) {
            if (value.getCoordinateValue() != null) {
                String interStr = this.interval.toString();
                float n = value.getCoordinateValue().floatValue();
                double f = this.unitToMS.convert((double)n);
                Date response = new Date(this.origin.getTime() + Double.doubleToLongBits(f));
                return response;
            }
            return null;
        }
        throw new IllegalArgumentException("The TemporalCoordinate argument must be a TemporalCoordinate ! ");
    }

    public TemporalCoordinate transformDateTime(Date dateTime) {
        if (this.msToUnit == null) {
            this.msToUnit = this.unitToMS != null ? this.unitToMS.inverse() : UNIT_MS.getConverterTo(this.interval);
        }
        Number coordinateValue = Math.abs(dateTime.getTime() - this.origin.getTime());
        float val = ((Number)coordinateValue).floatValue();
        coordinateValue = this.msToUnit.convert((double)val);
        return new DefaultTemporalCoordinate(this, null, coordinateValue);
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        boolean sup = super.equals(object, mode);
        if (!sup) {
            return false;
        }
        if (object instanceof DefaultTemporalCoordinateSystem) {
            DefaultTemporalCoordinateSystem that = (DefaultTemporalCoordinateSystem)((Object)object);
            return Objects.equals(this.interval, that.interval) && Objects.equals(this.origin, that.origin);
        }
        return false;
    }

    protected long computeHashCode() {
        int hash = 5;
        hash = 37 * hash + (this.interval != null ? this.interval.hashCode() : 0);
        hash = 37 * hash + (this.origin != null ? this.origin.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(super.toString()).append('\n').append("TemporalCoordinateSystem:").append('\n');
        if (this.interval != null) {
            s.append("interval:").append(this.interval).append('\n');
        }
        if (this.origin != null) {
            s.append("origin:").append(this.origin).append('\n');
        }
        return s.toString();
    }

    private static final class Interval {
        @XmlValue
        private static final double VALUE = 1.0;
        @XmlAttribute
        private final Unit<Time> unit;

        private Interval(Unit<Time> unit) {
            this.unit = unit;
        }
    }
}

