/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.awt.geom.Line2D;
import java.io.Serializable;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.resources.Errors;

public class VectorPair
implements Serializable {
    private static final long serialVersionUID = 8330893190189236019L;
    protected Vector X;
    protected Vector Y;

    public VectorPair(Vector X, Vector Y) {
        this.X = X;
        ArgumentChecks.ensureNonNull((String)"X", (Object)this.X);
        this.Y = Y;
        ArgumentChecks.ensureNonNull((String)"Y", (Object)this.Y);
    }

    public Vector getX() {
        return this.X;
    }

    public Vector getY() {
        return this.Y;
    }

    public int length() {
        int length = this.Y.size();
        if (length != this.X.size()) {
            throw new IllegalArgumentException(Errors.format((short)91));
        }
        return length;
    }

    public void omitColinearPoints(double xTolerance, double yTolerance) {
        int length = this.length();
        double ratio = yTolerance / xTolerance;
        if (!Double.isNaN(ratio)) {
            Vector X = this.X;
            Vector Y = this.Y;
            int[] indices = null;
            int count = 0;
            if (length >= 3) {
                yTolerance *= yTolerance;
                double x1 = X.doubleValue(0) * ratio;
                double y1 = Y.doubleValue(0);
                double x2 = X.doubleValue(1) * ratio;
                double y2 = Y.doubleValue(1);
                for (int i = 2; i < length; ++i) {
                    double y3;
                    double x3 = X.doubleValue(i) * ratio;
                    double dsq = Line2D.ptSegDistSq(x1, y1, x3, y3 = Y.doubleValue(i), x2, y2);
                    if (dsq <= yTolerance) {
                        if (indices == null) {
                            indices = new int[length - 1];
                            while (count < i) {
                                indices[count] = count++;
                            }
                        }
                        indices[count - 1] = i;
                    } else {
                        if (indices != null) {
                            indices[count++] = i;
                        }
                        x1 = x2;
                        y1 = y2;
                    }
                    x2 = x3;
                    y2 = y3;
                }
            }
            if (indices != null) {
                indices = ArraysExt.resize(indices, (int)count);
                this.X = X.pick(indices);
                this.Y = Y.pick(indices);
            }
        }
    }

    public void makeStepwise(int direction) {
        Vector X = this.X;
        Vector Y = this.Y;
        int length = Y.size();
        if (length + 1 != X.size()) {
            throw new IllegalArgumentException("Mismatched vector lengths.");
        }
        int[] Xi = new int[length * 2];
        int[] Yi = new int[length * 2];
        if (length != 0) {
            boolean swap = false;
            double x0 = X.doubleValue(0);
            double y0 = Y.doubleValue(0);
            int j = 0;
            for (int i = 0; i < length; ++i) {
                if (direction != 0) {
                    if (i + 1 == length) {
                        swap = false;
                    } else {
                        boolean up;
                        int xs;
                        double xi = X.doubleValue(i + 1);
                        double yi = Y.doubleValue(i + 1);
                        int n = xi > x0 ? 1 : (xs = xi < x0 ? -1 : 0);
                        if (xs != 0 && ((up = direction >= 0 ^ xs < 0 ^ swap) ? yi > y0 : yi < y0)) {
                            swap = !swap;
                        }
                        x0 = xi;
                        y0 = yi;
                    }
                }
                Xi[j] = i;
                Yi[j++] = i;
                Xi[j] = swap ? i : i + 1;
                Yi[j++] = swap ? i + 1 : i;
            }
            assert (ArraysExt.isSorted((int[])Xi, (boolean)false));
            assert (ArraysExt.isSorted((int[])Yi, (boolean)false));
            if (Math.abs(direction) >= 2) {
                int size;
                direction = Integer.signum(direction);
                int i = size = Xi.length;
                while (--i >= 2) {
                    double y2;
                    if (Xi[i] != Xi[i - 2]) continue;
                    y0 = Y.doubleValue(Yi[i - 2]) * (double)direction;
                    double y1 = Y.doubleValue(Yi[i - 1]) * (double)direction;
                    if (!(y1 < Math.min(y0, y2 = Y.doubleValue(Yi[i]) * (double)direction))) continue;
                    System.arraycopy(Xi, i, Xi, i - 1, size - i);
                    System.arraycopy(Yi, i, Yi, i - 1, size - i);
                    --size;
                }
                Xi = ArraysExt.resize((int[])Xi, (int)size);
                Yi = ArraysExt.resize((int[])Yi, (int)size);
            }
        }
        this.X = X.pick(Xi);
        this.Y = Y.pick(Yi);
    }
}

