/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.Stereographic;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

class EquatorialStereographic
extends Stereographic {
    private static final long serialVersionUID = -5098015759558831875L;

    protected EquatorialStereographic(OperationMethod method, Parameters parameters) {
        super(method, parameters);
        assert (this.\u03c60 == 0.0) : this.\u03c60;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03bb = Math.cos(\u03bb);
        double ssfn = this.ssfn(\u03c6, sin\u03c6);
        if (dstPts != null) {
            double \u03c7 = 2.0 * Math.atan(ssfn) - 1.5707963267948966;
            double cos\u03c7 = Math.cos(\u03c7);
            double A = 1.0 + cos\u03c7 * cos\u03bb;
            double x = cos\u03c7 * sin\u03bb / A;
            double y = Math.sin(\u03c7) / A;
            assert (super.transform(srcPts, srcOff, dstPts, dstOff, false) == null && Assertions.checkTransform(dstPts, dstOff, x, y));
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        double A = 1.0 + ssfn * ssfn;
        double d\u03c7_d\u03c6 = 2.0 * this.dssfn_d\u03c6(\u03c6, sin\u03c6, Math.cos(\u03c6)) * ssfn / A;
        double sin\u03c7 = (ssfn * ssfn - 1.0) / A;
        double cos\u03c7 = 2.0 * ssfn / A;
        double cos\u03c7cos\u03bb = cos\u03c7 * cos\u03bb;
        double cos\u03c7sin\u03bb = cos\u03c7 * sin\u03bb;
        double sin\u03c7cos\u03bb = sin\u03c7 * cos\u03bb;
        double F = 1.0 + cos\u03c7cos\u03bb;
        return new Matrix2((cos\u03c7sin\u03bb * cos\u03c7sin\u03bb / F + cos\u03c7cos\u03bb) / F, (sin\u03c7cos\u03bb * cos\u03c7sin\u03bb / F - sin\u03c7 * sin\u03bb) * d\u03c7_d\u03c6 / F, cos\u03c7sin\u03bb * sin\u03c7 / (F * F), (sin\u03c7cos\u03bb * sin\u03c7 / F + cos\u03c7) * d\u03c7_d\u03c6 / F);
    }

    static final class Spherical
    extends EquatorialStereographic {
        private static final long serialVersionUID = -4790138052004333003L;

        protected Spherical(OperationMethod method, Parameters parameters) {
            super(method, parameters);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double sin\u03c6 = Math.sin(\u03c6);
            double sin\u03bb = Math.sin(\u03bb);
            double cos\u03c6 = Math.cos(\u03c6);
            double cos\u03bb = Math.cos(\u03bb);
            double cos\u03c6cos\u03bb = cos\u03c6 * cos\u03bb;
            double cos\u03c6sin\u03bb = cos\u03c6 * sin\u03bb;
            double F = 1.0 + cos\u03c6cos\u03bb;
            double x = cos\u03c6sin\u03bb / F;
            double y = sin\u03c6 / F;
            Matrix2 derivative = null;
            if (derivate) {
                double sin\u03c6cos\u03bb = sin\u03c6 * cos\u03bb;
                derivative = new Matrix2((cos\u03c6sin\u03bb * cos\u03c6sin\u03bb / F + cos\u03c6cos\u03bb) / F, (sin\u03c6cos\u03bb * cos\u03c6sin\u03bb / F - sin\u03c6 * sin\u03bb) / F, cos\u03c6sin\u03bb * sin\u03c6 / (F * F), (sin\u03c6cos\u03bb * sin\u03c6 / F + cos\u03c6) / F);
            }
            assert (Assertions.checkDerivative(derivative, super.transform(srcPts, srcOff, dstPts, dstOff, derivate)) && Assertions.checkTransform(dstPts, dstOff, x, y));
            if (dstPts != null) {
                dstPts[dstOff] = x;
                dstPts[dstOff + 1] = y;
            }
            return derivative;
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double \u03c1 = Math.hypot(x, y);
            if (\u03c1 < 1.0E-6) {
                y = 0.0;
                x = 0.0;
            } else {
                double c = 2.0 * Math.atan(\u03c1);
                double sinc = Math.sin(c);
                double ct = \u03c1 * Math.cos(c);
                double t = x * sinc;
                y = Math.asin(y * sinc / \u03c1);
                x = Math.atan2(t, ct);
            }
            assert (this.checkInverseTransform(srcPts, srcOff, dstPts, dstOff, x, y));
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }

        private boolean checkInverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, double \u03bb, double \u03c6) throws ProjectionException {
            super.inverseTransform(srcPts, srcOff, dstPts, dstOff);
            return Assertions.checkInverseTransform(dstPts, dstOff, \u03bb, \u03c6);
        }
    }
}

