/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

public class CheckedArrayList<E>
extends ArrayList<E>
implements CheckedContainer<E>,
Cloneable {
    private static final long serialVersionUID = -8265578982723471814L;
    private final Class<E> type;

    public CheckedArrayList(Class<E> type) {
        this.type = type;
        ArgumentChecks.ensureNonNull((String)"type", type);
    }

    public CheckedArrayList(Class<E> type, int capacity) {
        super(capacity);
        this.type = type;
        ArgumentChecks.ensureNonNull((String)"type", type);
    }

    public Class<E> getElementType() {
        return this.type;
    }

    protected void ensureValid(E element) throws IllegalArgumentException {
        if (element != null && !this.type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format((short)43, (Object)"element", this.type, element.getClass()));
        }
    }

    private void ensureValidCollection(Collection<? extends E> collection) throws IllegalArgumentException {
        for (E element : collection) {
            this.ensureValid(element);
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
        assert (Thread.holdsLock(this.getLock()));
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.getLock();
        synchronized (object) {
            return new Iter(this, super.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator() {
        Object object = this.getLock();
        synchronized (object) {
            return new ListIter(super.listIterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return new ListIter(super.listIterator(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.lastIndexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return super.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(element);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E element) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(element);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(element);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidCollection(collection);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidCollection(collection);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.addAll(index, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trimToSize() {
        Object object = this.getLock();
        synchronized (object) {
            super.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureCapacity(int minCapacity) {
        Object object = this.getLock();
        synchronized (object) {
            super.ensureCapacity(minCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedArrayList<E> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedArrayList)super.clone();
        }
    }

    private static class Iter<I extends Iterator<E>>
    implements Iterator<E> {
        protected final I iterator;
        final /* synthetic */ CheckedArrayList this$0;

        Iter(I iterator) {
            this.this$0 = var1_1;
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean hasNext() {
            Object object = this.this$0.getLock();
            synchronized (object) {
                return this.iterator.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final E next() throws NoSuchElementException {
            Object object = this.this$0.getLock();
            synchronized (object) {
                return this.iterator.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void remove() throws UnsupportedOperationException {
            Object object = this.this$0.getLock();
            synchronized (object) {
                this.this$0.checkWritePermission();
                this.iterator.remove();
            }
        }
    }

    private class ListIter
    extends Iter<ListIterator<E>>
    implements ListIterator<E> {
        ListIter(ListIterator<E> iterator) {
            super(CheckedArrayList.this, iterator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int nextIndex() {
            Object object = CheckedArrayList.this.getLock();
            synchronized (object) {
                return ((ListIterator)this.iterator).nextIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int previousIndex() {
            Object object = CheckedArrayList.this.getLock();
            synchronized (object) {
                return ((ListIterator)this.iterator).previousIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() {
            Object object = CheckedArrayList.this.getLock();
            synchronized (object) {
                return ((ListIterator)this.iterator).hasPrevious();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() throws NoSuchElementException {
            Object object = CheckedArrayList.this.getLock();
            synchronized (object) {
                return ((ListIterator)this.iterator).previous();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E element) throws IllegalArgumentException, UnsupportedOperationException {
            CheckedArrayList.this.ensureValid(element);
            Object object = CheckedArrayList.this.getLock();
            synchronized (object) {
                CheckedArrayList.this.checkWritePermission();
                ((ListIterator)this.iterator).set(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E element) throws IllegalArgumentException, UnsupportedOperationException {
            CheckedArrayList.this.ensureValid(element);
            Object object = CheckedArrayList.this.getLock();
            synchronized (object) {
                CheckedArrayList.this.checkWritePermission();
                ((ListIterator)this.iterator).add(element);
            }
        }
    }
}

