/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.spi.QuantityFactory;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.IdentityConverter;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.Scalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.resources.Errors;

final class SystemUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements QuantityFactory<Q> {
    private static final long serialVersionUID = 4097466138698631914L;
    static final String ONE = "1";
    final Class<Q> quantity;
    final UnitDimension dimension;
    final transient ScalarFactory<Q> factory;
    private transient ConventionalUnit<Q>[] related;

    SystemUnit(Class<Q> quantity, UnitDimension dimension, String symbol, byte scope, short epsg, ScalarFactory<Q> factory) {
        super(symbol, scope, epsg);
        this.quantity = quantity;
        this.dimension = dimension;
        this.factory = factory;
    }

    private SystemUnit<?> create(UnitDimension newDimension, char operation, Unit<?> other) {
        SystemUnit<?> result;
        SystemUnit<?> result2;
        boolean deferred;
        String ts = this.getSymbol();
        boolean inverse = ts != null && ts.isEmpty() && operation == '\u2215';
        boolean bl = deferred = newDimension.isDimensionless() || !inverse && this.dimension.isDimensionless() || other != null && UnitDimension.isDimensionless(other.getDimension());
        if (!deferred && (result2 = Units.get(newDimension)) != null) {
            return result2;
        }
        String symbol = null;
        if (operation != '\u0000') {
            symbol = this.inferSymbol(operation, other);
        }
        if (deferred && (result = Units.get(newDimension)) != null && result.sameSymbol(symbol)) {
            return result;
        }
        if (newDimension == this.dimension && this.sameSymbol(symbol)) {
            return this;
        }
        return new SystemUnit<Q>(null, newDimension, symbol, 0, 0, null);
    }

    private boolean sameSymbol(String symbol) {
        return symbol == null || symbol.equals(this.getSymbol());
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public SystemUnit<Q> getSystemUnit() {
        return this;
    }

    @Override
    public Map<SystemUnit<?>, Integer> getBaseUnits() {
        Map<UnitDimension, Integer> dim = this.dimension.getBaseDimensions();
        if (dim == null) {
            return null;
        }
        return ObjectConverters.derivedKeys(dim, DimToUnit.INSTANCE, Integer.class);
    }

    @Override
    final Map<SystemUnit<?>, Fraction> getBaseSystemUnits() {
        return ObjectConverters.derivedKeys(this.dimension.components, DimToUnit.INSTANCE, Fraction.class);
    }

    @Override
    public <T extends Quantity<T>> Unit<T> asType(Class<T> type) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        if (type == this.quantity) {
            SystemUnit<T> unit;
            if (this.getSymbol() == null && (unit = Units.get(type)) != null) {
                return unit;
            }
            return this;
        }
        SystemUnit<T> unit = Units.get(type);
        if (unit == null) {
            unit = new SystemUnit<T>(type, this.dimension, null, 0, 0, null);
        }
        if (!this.dimension.equals(unit.dimension)) {
            throw new ClassCastException(Errors.format((short)64, new Object[]{this, this.quantity != null ? this.quantity.getSimpleName() : "?", this.dimension, type.getSimpleName(), unit.dimension}));
        }
        return unit;
    }

    final boolean equalsIgnoreMetadata(Unit<Q> other) {
        Class<Q> c;
        if (this.quantity != null && other instanceof SystemUnit && (c = ((SystemUnit)other).quantity) != null) {
            return this.quantity == c;
        }
        assert (other == other.getSystemUnit()) : other;
        return this.dimension.equals(other.getDimension());
    }

    @Override
    public UnitConverter getConverterTo(Unit<Q> unit) throws UnconvertibleException {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit<Q> step = unit.getSystemUnit();
        if (step != this && !this.equalsIgnoreMetadata(step)) {
            throw new UnconvertibleException(this.incompatible(unit));
        }
        if (step == unit) {
            return IdentityConverter.INSTANCE;
        }
        return unit.getConverterTo(step).inverse();
    }

    @Override
    public UnitConverter getConverterToAny(Unit<?> unit) throws IncommensurableException {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit<?> step = unit.getSystemUnit();
        if (step != this && !this.isCompatible(step)) {
            throw new IncommensurableException(this.incompatible(unit));
        }
        if (step == unit) {
            return IdentityConverter.INSTANCE;
        }
        return unit.getConverterToAny(step).inverse();
    }

    @Override
    public Unit<Q> alternate(String symbol) {
        ArgumentChecks.ensureNonEmpty("symbol", symbol);
        int c = SystemUnit.invalidCharForSymbol(symbol, 0, false);
        if (c >= 0) {
            throw new IllegalArgumentException(Errors.format((short)49, "symbol", String.valueOf(Character.toChars(c))));
        }
        if (symbol.equals(this.getSymbol())) {
            return this;
        }
        SystemUnit<Q> alt = new SystemUnit<Q>(this.quantity, this.dimension, symbol, 0, 0, this.factory);
        if (this.quantity != null) {
            Object existing = UnitRegistry.putIfAbsent(symbol, alt);
            if (existing != null) {
                if (existing instanceof SystemUnit) {
                    SystemUnit unit = (SystemUnit)existing;
                    if (this.quantity.equals(unit.quantity) && this.dimension.equals(unit.dimension)) {
                        return unit;
                    }
                }
                throw new IllegalArgumentException(Errors.format((short)27, symbol));
            }
            UnitRegistry.putIfAbsent(this.quantity, alt);
        }
        return alt;
    }

    @Override
    public Unit<?> multiply(Unit<?> multiplier) {
        ArgumentChecks.ensureNonNull("multiplier", multiplier);
        if (multiplier == this) {
            return this.pow(2);
        }
        return this.product(multiplier, false);
    }

    @Override
    public Unit<?> divide(Unit<?> divisor) {
        ArgumentChecks.ensureNonNull("divisor", divisor);
        return this.product(divisor, true);
    }

    private <T extends Quantity<T>> Unit<?> product(Unit<T> other, boolean inverse) {
        UnitDimension newDimension;
        char operation;
        Unit<T> intermediate = other.getSystemUnit();
        Dimension dim = intermediate.getDimension();
        if (inverse) {
            operation = '\u2215';
            newDimension = this.dimension.divide(dim);
        } else {
            operation = '\u22c5';
            newDimension = this.dimension.multiply(dim);
        }
        boolean transformed = intermediate != other;
        Unit<Object> result = this.create(newDimension, operation, transformed ? null : other);
        if (transformed) {
            UnitConverter c = other.getConverterTo(intermediate);
            if (!c.isLinear()) {
                throw new IllegalArgumentException(Errors.format((short)104, other));
            }
            if (!c.isIdentity()) {
                if (inverse) {
                    c = c.inverse();
                }
                result = result.transform(c);
                result = this.inferSymbol(result, operation, other);
            }
        }
        return result;
    }

    @Override
    public Unit<?> pow(int n) {
        switch (n) {
            case 0: {
                return Units.UNITY;
            }
            case 1: {
                return this;
            }
        }
        char p = n >= 0 && n <= 9 ? Characters.toSuperScript((char)(48 + n)) : (char)'\u0000';
        return this.create(this.dimension.pow(n), p, null);
    }

    @Override
    public Unit<?> root(int n) {
        return this.create(this.dimension.root(n), '\u0000', null);
    }

    @Override
    public Unit<Q> transform(UnitConverter operation) {
        ArgumentChecks.ensureNonNull("operation", operation);
        AbstractUnit base = this;
        ConventionalUnit pseudo = Prefixes.pseudoSystemUnit(this);
        if (pseudo != null) {
            operation = operation.concatenate(pseudo.toTarget.inverse());
            base = pseudo;
        }
        return ConventionalUnit.create(base, operation);
    }

    final void related(int n) {
        if (this.related != null) {
            throw new IllegalStateException();
        }
        this.related = new ConventionalUnit[n];
    }

    @Override
    final ConventionalUnit<Q>[] related() {
        return this.related;
    }

    @Override
    public boolean equals(Object other, ComparisonMode mode) {
        if (other == this) {
            return true;
        }
        if (super.equals(other, mode)) {
            SystemUnit that = (SystemUnit)other;
            return Objects.equals(this.quantity, that.quantity) && this.dimension.equals(that.dimension);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.dimension.hashCode();
    }

    @Override
    public Quantity<Q> create(Number value, Unit<Q> unit) {
        ArgumentChecks.ensureNonNull("value", value);
        ArgumentChecks.ensureNonNull("unit", unit);
        double v = AbstractConverter.doubleValue(value);
        if (this.factory != null) {
            return this.factory.create(v, unit);
        }
        if (this.quantity != null) {
            return ScalarFallback.factory(v, unit, this.quantity);
        }
        return new Scalar<Q>(v, unit);
    }

    @Override
    public Quantity<Q> create(Number value, Unit<Q> unit, Quantity.Scale scale) {
        if (Objects.requireNonNull(scale) != Scalar.SCALE) {
            throw new UnsupportedOperationException("Relative scale is not yet supported.");
        }
        return this.create(value, unit);
    }

    private static final class DimToUnit
    extends SurjectiveConverter<UnitDimension, SystemUnit<?>>
    implements Serializable {
        private static final long serialVersionUID = 7545067577687885675L;
        static final DimToUnit INSTANCE = new DimToUnit();

        private DimToUnit() {
        }

        @Override
        public Class<UnitDimension> getSourceClass() {
            return UnitDimension.class;
        }

        @Override
        public Class<SystemUnit<?>> getTargetClass() {
            return SystemUnit.class;
        }

        @Override
        public SystemUnit<?> apply(UnitDimension dim) {
            return Units.get(dim);
        }

        Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

