/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.internal.coverage.j2d.FillValues;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TilePlaceholder;
import org.apache.sis.internal.util.Numerics;

final class MaskedImage
extends SourceAlignedImage {
    private final Shape clip;
    private final boolean maskInside;
    private volatile transient Rectangle maskBounds;
    private volatile transient Rectangle maskTiles;
    private transient SoftReference<ByteBuffer> maskRef;
    private transient int maskScanlineStride;
    private final FillValues fillValues;
    private volatile transient TilePlaceholder emptyTiles;

    MaskedImage(RenderedImage source, Shape clip, boolean maskInside, Number[] fillValues) {
        super(source);
        this.clip = clip;
        this.maskInside = maskInside;
        this.fillValues = new FillValues(this.sampleModel, fillValues, true);
    }

    @Override
    public Object getProperty(String key) {
        return POSITIONAL_PROPERTIES.contains(key) ? this.getSource().getProperty(key) : super.getProperty(key);
    }

    @Override
    public String[] getPropertyNames() {
        return MaskedImage.filterPropertyNames(this.getSource().getPropertyNames(), POSITIONAL_PROPERTIES, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getMaskTiles() {
        Rectangle bt = this.maskTiles;
        if (bt == null) {
            MaskedImage maskedImage = this;
            synchronized (maskedImage) {
                bt = this.maskTiles;
                if (bt == null) {
                    RenderedImage source = this.getSource();
                    Rectangle bp = this.clip.getBounds();
                    ImageUtilities.clipBounds(source, bp);
                    bt = new Rectangle();
                    if (!bp.isEmpty()) {
                        int xmax = ImageUtilities.pixelToTileX(source, bp.x + bp.width - 1) + 1;
                        int ymax = ImageUtilities.pixelToTileY(source, bp.y + bp.height - 1) + 1;
                        bt.x = ImageUtilities.pixelToTileX(source, bp.x);
                        bt.width = xmax - bt.x;
                        bt.y = ImageUtilities.pixelToTileY(source, bp.y);
                        bt.height = ymax - bt.y;
                    }
                    this.maskBounds = bp;
                    this.maskTiles = bt;
                }
            }
        }
        return bt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteBuffer getMask() {
        ByteBuffer mask;
        if (this.maskRef == null || (mask = this.maskRef.get()) == null) {
            Rectangle maskBounds = this.maskBounds;
            int size = Numerics.ceilDiv(maskBounds.width, 8) * maskBounds.height;
            int r = size & 7;
            if (r != 0) {
                size += 8 - r;
            }
            DataBufferByte buffer = new DataBufferByte(size);
            byte[] gray = new byte[]{0, -1};
            IndexColorModel cm = new IndexColorModel(1, gray.length, gray, gray, gray);
            WritableRaster raster = Raster.createPackedRaster(buffer, maskBounds.width, maskBounds.height, 1, null);
            Graphics2D g = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null).createGraphics();
            try {
                g.translate(-maskBounds.x, -maskBounds.y);
                g.setColor(Color.WHITE);
                g.fill(this.clip);
            }
            finally {
                g.dispose();
            }
            mask = ByteBuffer.wrap(buffer.getData());
            if (this.maskInside) {
                LongBuffer b = mask.order(ByteOrder.nativeOrder()).asLongBuffer();
                while (b.hasRemaining()) {
                    b.put(b.position(), b.get() ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            mask = mask.order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer();
            MultiPixelPackedSampleModel sm = (MultiPixelPackedSampleModel)raster.getSampleModel();
            assert (sm.getNumDataElements() == 1 && sm.getPixelBitStride() == 1 && sm.getDataBitOffset() == 0);
            this.maskScanlineStride = sm.getScanlineStride() * 8;
            this.maskRef = new SoftReference<ByteBuffer>(mask);
        }
        return mask;
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster tile) {
        boolean isFullTile;
        RenderedImage source = this.getSource();
        int xmin = ImageUtilities.tileToPixelX(source, tileX);
        int ymin = ImageUtilities.tileToPixelY(source, tileY);
        if (!this.getMaskTiles().contains(tileX, tileY)) {
            if (this.maskInside) {
                return source.getTile(tileX, tileY);
            }
            return this.createEmptyTile(xmin, ymin);
        }
        Rectangle maskBounds = this.maskBounds;
        LongBuffer mask = this.getMask().asLongBuffer();
        int xmax = xmin + source.getTileWidth();
        int ymax = ymin + source.getTileHeight();
        int xEnd = Math.min(xmax, maskBounds.x + maskBounds.width);
        int yEnd = Math.min(ymax, maskBounds.y + maskBounds.height);
        int xStart = Math.max(xmin, maskBounds.x);
        int yStart = Math.max(ymin, maskBounds.y);
        int imax = xEnd - maskBounds.x;
        int xoff = xStart - maskBounds.x;
        Raster data = null;
        Object transfer = null;
        int transferSize = 0;
        long present = -1L;
        block6: for (int y = yStart; y < yEnd; ++y) {
            int index = (y - maskBounds.y) * this.maskScanlineStride;
            int emax = index + imax >>> 6;
            int shift = (index += xoff) & 0x3F;
            int base = xStart - ((index >>>= 6) * 64 + shift);
            int remaining = xEnd - (base + emax * 64);
            assert (remaining >= 0 && remaining < 64) : remaining;
            long element = mask.get(index);
            long m = Numerics.bitmask(64 - shift) - 1L;
            if (index == emax && remaining != 0) {
                m &= -(1L << 64 - remaining);
            }
            present &= element | m ^ 0xFFFFFFFFFFFFFFFFL;
            element &= m;
            while (true) {
                if (element != 0L) {
                    int lower = Long.numberOfLeadingZeros(element);
                    int upper = Long.numberOfLeadingZeros((element ^ 0xFFFFFFFFFFFFFFFFL) & (1L << 63 - lower) - 1L);
                    int x = base + index * 64 + lower;
                    int count = upper - lower;
                    assert (count > 0 && count <= 64) : count;
                    if (count > transferSize) {
                        if (data == null) {
                            data = source.getTile(tileX, tileY);
                            assert (data.getMinX() == xmin && data.getMinY() == ymin);
                            boolean clean = this.needCreate(tile, data);
                            if (clean) {
                                tile = this.createTile(tileX, tileY);
                                clean = this.fillValues.isFullyZero;
                            }
                            if (!clean) {
                                this.fillValues.fill(tile);
                            }
                        }
                        transferSize = count;
                        transfer = null;
                    }
                    transfer = data.getDataElements(x, y, count, 1, transfer);
                    tile.setDataElements(x, y, count, 1, transfer);
                    element &= (1L << 64 - upper) - 1L;
                    continue;
                }
                if (++index < emax) {
                    element = mask.get(index);
                    present &= element;
                    continue;
                }
                if (index != emax || remaining == 0) continue block6;
                m = (1L << 64 - remaining) - 1L;
                element = mask.get(index);
                present &= element | m;
                element &= m ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        boolean bl = isFullTile = xStart == xmin && yStart == ymin && xEnd == xmax && yEnd == ymax;
        if (data == null) {
            if (isFullTile) {
                return this.createEmptyTile(xmin, ymin);
            }
            data = source.getTile(tileX, tileY);
            boolean clean = this.needCreate(tile, data);
            if (clean) {
                tile = this.createTile(tileX, tileY);
                clean = this.fillValues.isFullyZero;
            }
            if (!clean) {
                this.fillValues.fill(tile);
            }
        }
        assert (data.getMinX() == xmin && data.getMinY() == ymin);
        if (present == -1L && isFullTile | this.maskInside) {
            return data;
        }
        if (this.maskInside) {
            int width = xmax - xmin;
            int height = yEnd - yStart;
            int border = 0;
            block8: while (true) {
                int span;
                int start;
                switch (border) {
                    case 0: {
                        start = ymin;
                        span = yStart - start;
                        break;
                    }
                    case 1: {
                        start = yEnd;
                        span = ymax - start;
                        break;
                    }
                    case 2: {
                        start = xmin;
                        span = xStart - start;
                        break;
                    }
                    case 3: {
                        start = xEnd;
                        span = xmax - start;
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                boolean horizontal = (border & 2) == 0;
                int area = span * (horizontal ? width : height);
                if (area > 0) {
                    if (area > transferSize) {
                        transferSize = area;
                        transfer = null;
                    }
                    if (horizontal) {
                        transfer = data.getDataElements(xmin, start, width, span, transfer);
                        tile.setDataElements(xmin, start, width, span, transfer);
                    } else {
                        transfer = data.getDataElements(start, yStart, span, height, transfer);
                        tile.setDataElements(start, yStart, span, height, transfer);
                    }
                }
                ++border;
            }
        }
        return tile;
    }

    private Raster createEmptyTile(int xmin, int ymin) {
        TilePlaceholder p = this.emptyTiles;
        if (p == null) {
            this.emptyTiles = p = TilePlaceholder.filled(this.sampleModel, this.fillValues);
        }
        return p.create(new Point(xmin, ymin));
    }

    private boolean needCreate(WritableRaster tile, Raster source) {
        if (tile == null || tile.getDataBuffer() == source.getDataBuffer()) {
            return true;
        }
        TilePlaceholder p = this.emptyTiles;
        return p != null && p.isCreatorOf(tile);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MaskedImage other = (MaskedImage)object;
            return this.clip.equals(other.clip) && this.fillValues.equals(other.fillValues);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.clip.hashCode() + this.fillValues.hashCode();
    }
}

