/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.util.Collection;
import java.util.EnumMap;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.FeatureType;
import org.opengis.filter.Expression;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

abstract class SpatialFunction<R>
extends Node
implements FeatureExpression<R, Object>,
Optimization.OnExpression<R, Object> {
    private static final long serialVersionUID = 6933519274722660893L;
    private static final LocalName SCOPE = Names.createLocalName("ISO", null, "sqlmm");
    final SQLMM operation;
    private static final EnumMap<SQLMM, ScopedName> NAMES = new EnumMap(SQLMM.class);

    SpatialFunction(SQLMM operation, Expression<R, ?>[] parameters) {
        this.operation = operation;
        ArgumentChecks.ensureCountBetween("parameters", true, operation.minParamCount, operation.maxParamCount, parameters.length);
    }

    abstract Geometries<?> getGeometryLibrary();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ScopedName getFunctionName() {
        EnumMap<SQLMM, ScopedName> enumMap = NAMES;
        synchronized (enumMap) {
            return NAMES.computeIfAbsent(this.operation, SpatialFunction::createName);
        }
    }

    private static ScopedName createName(SQLMM operation) {
        return Names.createScopedName((GenericName)SCOPE, null, operation.name());
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getParameters();
    }

    public String getSyntax() {
        byte minParamCount = this.operation.minParamCount;
        int maxParamCount = this.operation.maxParamCount;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFunctionName().tip()).append('(');
        for (int i = 0; i < maxParamCount; ++i) {
            if (i == minParamCount) {
                sb.append('[');
            }
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("param").append(i + 1);
        }
        if (maxParamCount > minParamCount) {
            sb.append(']');
        }
        return sb.append(')').toString();
    }

    @Override
    public final Class<?> getValueClass() {
        return this.operation.getReturnType(this.getGeometryLibrary());
    }

    public final <N> Expression<R, N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        throw new ClassCastException(Errors.format((short)8, this.getFunctionName(), target));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PropertyTypeBuilder expectedType(FeatureType valueType, FeatureTypeBuilder addTo) {
        AttributeTypeBuilder<?> att;
        if (this.operation.isGeometryInOut()) {
            Geometries library;
            PropertyTypeBuilder type;
            FeatureExpression<?, ?> fex = FeatureExpression.castOrCopy((Expression)this.getParameters().get(0));
            if (fex == null || !((type = fex.expectedType(valueType, addTo)) instanceof AttributeTypeBuilder) || (library = Geometries.implementation((att = (AttributeTypeBuilder<?>)type).getValueClass())) == null) throw new InvalidFilterValueException(Resources.format((short)52));
            att = att.setValueClass(this.operation.getReturnType(library));
            return att.setName((GenericName)this.getFunctionName());
        } else {
            att = addTo.addAttribute(this.getValueClass());
        }
        return att.setName((GenericName)this.getFunctionName());
    }
}

