/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.CharSequences;

public enum CodeType {
    FILE(false),
    URL(false),
    URN(true),
    HTTP_OGC(true),
    IDENTIFIER(true),
    UNKNOWN(false);

    public final boolean isCRS;
    private static final Map<String, CodeType> FOR_PROTOCOL;

    private CodeType(boolean isCRS) {
        this.isCRS = isCRS;
    }

    public static CodeType guess(String codeOrPath) {
        char c;
        int separator;
        int length = codeOrPath.length();
        int start = CharSequences.skipLeadingWhitespaces(codeOrPath, 0, length);
        int end = CharSequences.skipTrailingWhitespaces(codeOrPath, start, separator = codeOrPath.indexOf(58, start));
        if (end <= start) {
            if (codeOrPath.contains(File.separator) || codeOrPath.indexOf(47) >= 0 || codeOrPath.indexOf(92) >= 0) {
                return FILE;
            }
            return UNKNOWN;
        }
        do {
            if ((separator = CharSequences.skipLeadingWhitespaces(codeOrPath, separator + 1, length)) < length) continue;
            return FILE;
        } while ((c = codeOrPath.charAt(separator)) == '.');
        CodeType known = FOR_PROTOCOL.get(codeOrPath.substring(start, end).toLowerCase(Locale.US));
        if (known != null) {
            if (known != HTTP_OGC) {
                return known;
            }
            if (c == '/') {
                while (++separator < length) {
                    c = codeOrPath.charAt(separator);
                    if (c == '/') continue;
                    if (!CharSequences.regionMatches(codeOrPath, separator = CharSequences.skipLeadingWhitespaces(codeOrPath, separator, length), "www.opengis.net", true) || (separator += "www.opengis.net".length()) < length && codeOrPath.charAt(separator) != '/') break;
                    return known;
                }
            }
            return URL;
        }
        if (c == '/') {
            return URL;
        }
        if (c == '\\' || c == File.separatorChar || end == start + 1) {
            return FILE;
        }
        return IDENTIFIER;
    }

    static {
        FOR_PROTOCOL = new HashMap<String, CodeType>();
        FOR_PROTOCOL.put("urn", URN);
        FOR_PROTOCOL.put("http", HTTP_OGC);
        FOR_PROTOCOL.put("https", HTTP_OGC);
        FOR_PROTOCOL.put("shttp", HTTP_OGC);
        for (String p : new String[]{"cvs", "dav", "file", "ftp", "git", "jar", "nfs", "sftp", "ssh", "svn"}) {
            if (FOR_PROTOCOL.put(p, URL) != null) {
                throw new AssertionError((Object)p);
            }
        }
    }
}

