/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.internal.coverage.RangeArgument;
import org.apache.sis.internal.storage.TiledGridCoverage;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.opengis.coverage.CannotEvaluateException;

public abstract class TiledGridResource
extends AbstractGridCoverageResource {
    private final WeakValueHashMap<CacheKey, Raster> rasters = new WeakValueHashMap(CacheKey.class);
    private RasterLoadingStrategy loadingStrategy;

    protected TiledGridResource(StoreListeners parent) {
        super(parent, false);
    }

    protected abstract int[] getTileSize();

    protected int getAtomSize(boolean xdim) throws DataStoreException {
        return xdim ? TiledGridCoverage.getPixelsPerElement(this.getSampleModel()) : 1;
    }

    protected boolean getDissociableBands() throws DataStoreException {
        return this.getSampleModel() instanceof ComponentSampleModel;
    }

    protected abstract SampleModel getSampleModel() throws DataStoreException;

    protected abstract ColorModel getColorModel() throws DataStoreException;

    protected abstract Number getFillValue() throws DataStoreException;

    protected final GridCoverage preload(GridCoverage coverage) throws DataStoreException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        if ((this.loadingStrategy == null || this.loadingStrategy == RasterLoadingStrategy.AT_READ_TIME) && coverage.getGridGeometry().getDimension() == 2) {
            try {
                RenderedImage image = coverage.render(null);
                return new GridCoverage2D(coverage.getGridGeometry(), coverage.getSampleDimensions(), image);
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DataStoreException) {
                    throw (DataStoreException)cause;
                }
                if (cause == null || !(e instanceof CannotEvaluateException)) {
                    cause = e;
                }
                throw new DataStoreException(e.getLocalizedMessage(), cause);
            }
        }
        return coverage;
    }

    private boolean supportImmediateLoading() {
        return this.getTileSize().length == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.loadingStrategy == null) {
                this.setLoadingStrategy(this.supportImmediateLoading());
            }
            return this.loadingStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (strategy == RasterLoadingStrategy.AT_GET_TILE_TIME) {
                this.loadingStrategy = strategy;
            } else if (strategy != null) {
                this.setLoadingStrategy(strategy == RasterLoadingStrategy.AT_READ_TIME && this.supportImmediateLoading());
            }
            return super.setLoadingStrategy(strategy);
        }
    }

    private void setLoadingStrategy(boolean loadAtReadTime) {
        this.loadingStrategy = loadAtReadTime ? RasterLoadingStrategy.AT_READ_TIME : RasterLoadingStrategy.AT_RENDER_TIME;
    }

    static final class CacheKey {
        private final int indexInTileVector;
        private final int[] includedBands;
        private final int[] subsampling;
        private final int[] subsamplingOffsets;

        CacheKey(int indexInTileVector, int[] includedBands, int[] subsampling, int[] subsamplingOffsets) {
            this.indexInTileVector = indexInTileVector;
            this.includedBands = includedBands;
            this.subsampling = subsampling;
            this.subsamplingOffsets = subsamplingOffsets;
        }

        public int hashCode() {
            return this.indexInTileVector + 73 * Arrays.hashCode(this.includedBands) + 1063 * Arrays.hashCode(this.subsampling) + 7919 * Arrays.hashCode(this.subsamplingOffsets);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return this.indexInTileVector == other.indexInTileVector && Arrays.equals(this.includedBands, other.includedBands) && Arrays.equals(this.subsampling, other.subsampling) && Arrays.equals(this.subsamplingOffsets, other.subsamplingOffsets);
            }
            return false;
        }
    }

    public final class Subset {
        final GridExtent sourceExtent;
        final GridExtent readExtent;
        final GridGeometry domain;
        final List<? extends SampleDimension> ranges;
        final int[] includedBands;
        final int[] subsampling;
        final int[] subsamplingOffsets;
        final int[] tileSize;
        final SampleModel modelForBandSubset;
        final ColorModel colorsForBandSubset;
        final Number fillValue;
        final WeakValueHashMap<CacheKey, Raster> cache;

        public Subset(GridGeometry domain, int[] range) throws DataStoreException {
            List<SampleDimension> bands = TiledGridResource.this.getSampleDimensions();
            RangeArgument rangeIndices = RangeArgument.validate(bands.size(), range, TiledGridResource.this.listeners);
            GridGeometry gridGeometry = TiledGridResource.this.getGridGeometry();
            this.sourceExtent = gridGeometry.getExtent();
            this.tileSize = TiledGridResource.this.getTileSize();
            boolean sharedCache = true;
            if (domain == null) {
                domain = gridGeometry;
                this.readExtent = this.sourceExtent;
                this.subsamplingOffsets = new int[gridGeometry.getDimension()];
                this.subsampling = new int[this.subsamplingOffsets.length];
                Arrays.fill(this.subsampling, 1);
            } else {
                int atomSizeX = TiledGridResource.this.getAtomSize(true);
                int atomSizeY = TiledGridResource.this.getAtomSize(false);
                int tileWidth = this.tileSize[0];
                int tileHeight = this.tileSize[1];
                if ((long)tileWidth >= this.sourceExtent.getSize(0)) {
                    tileWidth = atomSizeX;
                    sharedCache = false;
                }
                if ((long)tileHeight >= this.sourceExtent.getSize(1)) {
                    tileHeight = atomSizeY;
                    sharedCache = false;
                }
                int[] chunkSize = new int[]{tileWidth, tileHeight};
                int[] maximumSubsampling = new int[chunkSize.length];
                Arrays.fill(maximumSubsampling, Integer.MAX_VALUE);
                if (atomSizeX != 1) {
                    maximumSubsampling[0] = 1;
                }
                if (atomSizeY != 1) {
                    maximumSubsampling[1] = 1;
                }
                GridDerivation target = gridGeometry.derive().chunkSize(chunkSize).maximumSubsampling(maximumSubsampling).rounding(GridRoundingMode.ENCLOSING).subgrid(domain);
                domain = target.build();
                this.readExtent = target.getIntersection();
                this.subsampling = target.getSubsampling();
                this.subsamplingOffsets = target.getSubsamplingOffsets();
            }
            int[] includedBands = null;
            boolean loadAllBands = rangeIndices.isIdentity();
            if (!loadAllBands) {
                bands = Arrays.asList(rangeIndices.select(bands));
                boolean bl = loadAllBands = !TiledGridResource.this.getDissociableBands();
                if (!loadAllBands) {
                    sharedCache = false;
                    includedBands = new int[rangeIndices.getNumBands()];
                    for (int i = 0; i < includedBands.length; ++i) {
                        includedBands[i] = rangeIndices.getSourceIndex(i);
                    }
                    assert (ArraysExt.isSorted(includedBands, true));
                    if (rangeIndices.hasAllBands) {
                        assert (ArraysExt.isRange(0, includedBands));
                        includedBands = null;
                    }
                }
            }
            this.domain = domain;
            this.ranges = bands;
            this.includedBands = includedBands;
            this.modelForBandSubset = rangeIndices.select(TiledGridResource.this.getSampleModel(), loadAllBands);
            this.colorsForBandSubset = rangeIndices.select(TiledGridResource.this.getColorModel());
            this.fillValue = TiledGridResource.this.getFillValue();
            this.cache = sharedCache ? TiledGridResource.this.rasters : new WeakValueHashMap(CacheKey.class);
        }

        public boolean isXContiguous() {
            return this.includedBands == null && this.subsampling[0] == 1;
        }

        final boolean deferredTileReading() {
            if (TiledGridResource.this.loadingStrategy != RasterLoadingStrategy.AT_GET_TILE_TIME) {
                return false;
            }
            int i = this.subsampling.length;
            while (--i >= 0) {
                if (this.subsampling[i] < this.tileSize[i]) continue;
                return false;
            }
            return true;
        }
    }
}

