/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Supplier;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.util.logging.Logging;

public final class InputStreamArrayGetter
extends OutputStream {
    private ByteBuffer buffer;

    private InputStreamArrayGetter() {
    }

    private static boolean isKnownImplementation(InputStream input) {
        try {
            return input.getClass().getMethod("transferTo", OutputStream.class).getDeclaringClass() == ByteArrayInputStream.class;
        }
        catch (NoSuchMethodException e) {
            Logging.unexpectedException(StoreUtilities.LOGGER, InputStreamArrayGetter.class, "isKnownImplementation", e);
            return false;
        }
    }

    public static ChannelDataInput channel(String filename, InputStream input, Supplier<ByteBuffer> bs) throws IOException {
        if (InputStreamArrayGetter.isKnownImplementation(input)) {
            InputStreamArrayGetter getter = new InputStreamArrayGetter();
            input.transferTo(getter);
            if (getter.buffer != null) {
                return new ChannelDataInput(filename, getter.buffer);
            }
        }
        ReadableByteChannel channel = Channels.newChannel(input);
        return new ChannelDataInput(filename, channel, bs.get(), false);
    }

    @Override
    public void write(byte[] array, int offset, int length) throws IOException {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.wrap(array, offset, length);
        } else {
            super.write(array, offset, length);
        }
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Unexpected implementation.");
    }
}

