/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.resources.Errors;

final class ProbeReader
extends FilterReader {
    ProbeReader(StorageConnector owner, Reader input) throws IOException, DataStoreException {
        super(input);
        if (!input.markSupported()) {
            throw new DataStoreException(Resources.format((short)62, owner.getStorageName()));
        }
        input.mark(8192);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) throws IOException {
        throw new IOException(Errors.format((short)162, "mark"));
    }

    @Override
    public void reset() throws IOException {
        throw new IOException(Errors.format((short)162, "reset"));
    }

    @Override
    public void close() throws IOException {
        Reader input = this.in;
        this.in = null;
        if (input != null) {
            input.reset();
        }
    }
}

