/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.sis.feature.Features;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedFeatureSet;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureType;

public class ConcatenatedFeatureSet
extends AggregatedFeatureSet {
    private final List<FeatureSet> sources;
    private final FeatureType commonType;

    private ConcatenatedFeatureSet(FeatureSet[] sources, ConcatenatedFeatureSet original) {
        super(original.listeners);
        this.sources = UnmodifiableArrayList.wrap(sources);
        this.commonType = original.commonType;
    }

    protected ConcatenatedFeatureSet(Resource parent, FeatureSet[] sources) throws DataStoreException {
        super(parent);
        for (int i = 0; i < sources.length; ++i) {
            ArgumentChecks.ensureNonNullElement("sources", i, sources[i]);
        }
        this.sources = UnmodifiableArrayList.wrap(sources);
        FeatureType[] types = new FeatureType[sources.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = sources[i].getType();
        }
        this.commonType = Features.findCommonParent(Arrays.asList(types));
        if (this.commonType == null) {
            throw new DataStoreContentException(Resources.format((short)75));
        }
    }

    public static FeatureSet create(FeatureSet ... sources) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty("sources", sources);
        if (sources.length == 1) {
            FeatureSet fs = sources[0];
            ArgumentChecks.ensureNonNullElement("sources", 0, fs);
            return fs;
        }
        return new ConcatenatedFeatureSet(null, (FeatureSet[])sources.clone());
    }

    public static FeatureSet create(Collection<? extends FeatureSet> sources) throws DataStoreException {
        ArgumentChecks.ensureNonNull("sources", sources);
        int size = sources.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)29, "sources"));
            }
            case 1: {
                FeatureSet fs = CollectionsExt.first(sources);
                ArgumentChecks.ensureNonNullElement("sources", 0, fs);
                return fs;
            }
        }
        return new ConcatenatedFeatureSet(null, sources.toArray(new FeatureSet[size]));
    }

    final List<FeatureSet> dependencies() {
        return this.sources;
    }

    @Override
    public FeatureType getType() {
        return this.commonType;
    }

    @Override
    public OptionalLong getFeatureCount() {
        long sum = 0L;
        for (FeatureSet fs : this.sources) {
            long c;
            OptionalLong count;
            if (fs instanceof AbstractFeatureSet && (count = ((AbstractFeatureSet)fs).getFeatureCount()).isPresent() && (c = count.getAsLong()) >= 0L) {
                if ((sum += c) >= 0L) continue;
                sum = Long.MAX_VALUE;
                break;
            }
            return OptionalLong.empty();
        }
        return OptionalLong.of(sum);
    }

    @Override
    public Stream<Feature> features(boolean parallel) {
        Stream sets = parallel ? this.sources.parallelStream() : this.sources.stream();
        return sets.flatMap(set -> {
            try {
                return set.features(parallel);
            }
            catch (DataStoreException e) {
                throw new BackingStoreException(e);
            }
        });
    }

    @Override
    public FeatureSet subset(Query query) throws DataStoreException {
        FeatureSet[] subsets = new FeatureSet[this.sources.size()];
        boolean modified = false;
        for (int i = 0; i < subsets.length; ++i) {
            FeatureSet source = this.sources.get(i);
            subsets[i] = source.subset(query);
            modified |= subsets[i] != source;
        }
        return modified ? new ConcatenatedFeatureSet(subsets, this) : this;
    }
}

