/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.List;
import java.util.Locale;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class GroupByCRS<E>
extends Group<E> {
    private final CoordinateReferenceSystem crs;

    private GroupByCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    final String createName(Locale locale) {
        return IdentifiedObjects.getDisplayName((IdentifiedObject)this.crs, (Locale)locale);
    }

    static <E> GroupByCRS<E> getOrAdd(List<GroupByCRS<E>> groups, GridGeometry geometry) {
        return GroupByCRS.getOrAdd(groups, geometry.isDefined(1) ? geometry.getCoordinateReferenceSystem() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> GroupByCRS<E> getOrAdd(List<GroupByCRS<E>> groups, CoordinateReferenceSystem crs) {
        List<GroupByCRS<GroupByCRS<GroupByCRS<E>>>> list = groups;
        synchronized (list) {
            for (GroupByCRS<GroupByCRS<E>> groupByCRS : groups) {
                if (!Utilities.equalsIgnoreMetadata(crs, groupByCRS.crs)) continue;
                return groupByCRS;
            }
            GroupByCRS<E> c = new GroupByCRS<E>(crs);
            groups.add(c);
            return c;
        }
    }
}

