/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.time.Duration;
import java.time.Instant;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class MergeStrategy {
    private static final MergeStrategy SELECT_BY_TIME = new MergeStrategy(null);
    private final Duration timeGranularity;

    private MergeStrategy(Duration timeGranularity) {
        this.timeGranularity = timeGranularity;
    }

    public static MergeStrategy selectByTimeThenArea(Duration timeGranularity) {
        return timeGranularity != null ? new MergeStrategy(timeGranularity) : SELECT_BY_TIME;
    }

    final Integer apply(GridGeometry request, GridGeometry[] candidates) {
        ExtentSelector selector = new ExtentSelector((GeographicBoundingBox)request.getGeographicExtent().orElse(null), request.getTemporalExtent());
        if (this.timeGranularity != null) {
            selector.setTimeGranularity(this.timeGranularity);
            selector.alternateOrdering = true;
        }
        for (int i = 0; i < candidates.length; ++i) {
            GridGeometry candidate = candidates[i];
            if (candidate == null) continue;
            Instant[] t = candidate.getTemporalExtent();
            int n = t.length;
            selector.evaluate((GeographicBoundingBox)candidate.getGeographicExtent().orElse(null), n == 0 ? null : t[0], n == 0 ? null : t[n - 1], (Object)i);
        }
        return (Integer)selector.best();
    }

    public Resource apply(Resource resource) {
        if (resource instanceof AggregatedResource) {
            return ((AggregatedResource)((Object)resource)).apply(this);
        }
        return resource;
    }

    public String toString() {
        return Strings.toString(this.getClass(), "algo", "selectByTimeThenArea", "timeGranularity", this.timeGranularity);
    }
}

