/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data;

import java.io.File;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;

public class DataFixture {
    protected File dataFile;
    protected XSModel model;

    @BeforeClass(alwaysRun=true)
    public void initDataFixture(ITestContext testContext) {
        Assert.assertTrue((boolean)testContext.getSuite().getAttributeNames().contains(SuiteAttribute.GML.getName()), (String)"No GML data to validate.");
        this.dataFile = (File)testContext.getSuite().getAttribute(SuiteAttribute.GML.getName());
        this.model = (XSModel)testContext.getSuite().getAttribute(SuiteAttribute.XSMODEL.getName());
    }

    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    public void setSchemaModel(XSModel xsModel) {
        this.model = xsModel;
    }

    public String generateXPathExpression(List<QName> elemNames, Map<String, String> namespaceBindings) {
        StringBuilder xpath = new StringBuilder();
        ListIterator<QName> itr = elemNames.listIterator();
        while (itr.hasNext()) {
            QName qName = itr.next();
            String namespace = qName.getNamespaceURI();
            String prefix = namespaceBindings.get(namespace);
            if (null == prefix) {
                prefix = namespace.equals("http://www.opengis.net/gml/3.2") ? "gml" : "ns" + itr.previousIndex();
                namespaceBindings.put(namespace, prefix);
            }
            xpath.append("//").append(prefix).append(":");
            xpath.append(qName.getLocalPart());
            if (!itr.hasNext()) continue;
            xpath.append(" | ");
        }
        return xpath.toString();
    }
}

