/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.TestRunArg;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.URIUtils;
import org.opengis.cite.iso19136.util.ValidationUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.Reporter;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        Reporter.clear();
        this.processIUTParameter(suite);
        this.processRequiredSuiteParameters(suite);
        this.processSchematronSchema(suite);
        StringBuilder str = new StringBuilder("Initial test run parameters: ");
        str.append(suite.getXmlSuite().getAllParameters().toString());
        Reporter.log((String)str.toString());
        TestSuiteLogger.log(Level.CONFIG, str.toString());
    }

    public void onFinish(ISuite suite) {
        String reportDir = suite.getOutputDirectory();
        String msg = String.format("Test run directory: %s", reportDir.substring(0, reportDir.lastIndexOf(File.separatorChar)));
        Reporter.log((String)msg);
    }

    void processIUTParameter(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        String iutRef = (String)params.get(TestRunArg.IUT.toString());
        if (iutRef != null && !iutRef.isEmpty()) {
            try {
                File iutFile = URIUtils.resolveURIAsFile(URI.create(iutRef));
                if (this.isXMLSchema(iutFile)) {
                    params.put(TestRunArg.XSD.toString(), iutRef);
                } else {
                    params.put(TestRunArg.GML.toString(), iutRef);
                }
            }
            catch (Exception x) {
                throw new RuntimeException("Failed to read resource from " + iutRef, x);
            }
            params.remove(TestRunArg.IUT.toString());
        }
    }

    void processRequiredSuiteParameters(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String dataURI = (String)params.get(TestRunArg.GML.toString());
        File dataFile = null;
        HashSet<URI> schemaURIs = new HashSet<URI>();
        if (dataURI != null && !dataURI.isEmpty()) {
            try {
                dataFile = URIUtils.resolveURIAsFile(URI.create(dataURI));
                schemaURIs.addAll(ValidationUtils.extractSchemaReferences(new StreamSource(dataFile), dataURI));
            }
            catch (IOException iox) {
                throw new RuntimeException("Failed to obtain data from " + dataURI, iox);
            }
            catch (XMLStreamException xse) {
                throw new RuntimeException("Failed to get schema reference from source: " + dataFile.getAbsolutePath(), xse);
            }
        } else if (null != params.get(TestRunArg.XSD.toString())) {
            String xsdParam = (String)params.get(TestRunArg.XSD.toString());
            schemaURIs.add(URI.create(xsdParam));
        } else {
            String msg = "Missing required test run parameters: 'gml' or 'xsd' not found";
            TestSuiteLogger.log(Level.SEVERE, msg);
            Reporter.log((String)msg);
        }
        if (null != dataFile && dataFile.exists()) {
            suite.setAttribute(SuiteAttribute.GML.getName(), (Object)dataFile);
            TestSuiteLogger.log(Level.FINE, "GML data file: " + dataFile.getAbsolutePath());
        }
        suite.setAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName(), schemaURIs);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Schema references: ");
            logMsg.append(schemaURIs);
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    void processSchematronSchema(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        String schRef = (String)params.get(TestRunArg.SCH.toString());
        if (schRef != null && !schRef.isEmpty()) {
            URI schURI = URI.create((String)params.get(TestRunArg.SCH.toString()));
            suite.setAttribute(SuiteAttribute.SCHEMATRON.getName(), (Object)schURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isXMLSchema(File file) {
        if (!file.exists() || file.length() == 0L) {
            return false;
        }
        QName docElemName = QName.valueOf("");
        FileInputStream inStream = null;
        XMLEventReader reader = null;
        try {
            inStream = new FileInputStream(file);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            reader = factory.createXMLEventReader(inStream);
            StartElement docElem = reader.nextTag().asStartElement();
            docElemName = docElem.getName();
        }
        catch (Exception e1) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
                ((InputStream)inStream).close();
            }
            catch (Exception e2) {
                TestSuiteLogger.log(Level.INFO, "Error closing resource.", e2);
            }
        }
        return docElemName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema");
    }
}

