/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.components;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TopologyComponentTests
extends SchemaModelFixture {
    private XSTypeDefinition topoBaseType;

    @BeforeTest
    public void hasTopologyComponents(ITestContext testContext) {
        if (null == this.model) {
            this.model = (XSModel)testContext.getSuite().getAttribute(SuiteAttribute.XSMODEL.getName());
        }
        this.topoBaseType = this.model.getTypeDefinition("AbstractTopologyType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> topoElements = XMLSchemaModelUtils.getGlobalElementsByType(this.model, this.topoBaseType);
        XSElementDeclaration abstractTopo = this.model.getElementDeclaration("AbstractTopology", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> topoProps = XMLSchemaModelUtils.getImplicitProperties(this.model, abstractTopo);
        Assert.assertFalse((topoElements.isEmpty() && topoProps.isEmpty() ? 1 : 0) != 0, (String)"No GML topology (property) components found in schema.");
    }

    @Test
    public void substitutesForGMLTopology() {
        List<XSElementDeclaration> topoElems = XMLSchemaModelUtils.getTopologyDeclarations(this.model);
        Set<XSTypeDefinition> topoTypeDefs = XMLSchemaModelUtils.getDerivedTypeDefinitions(this.model, this.topoBaseType, (short)1);
        for (XSTypeDefinition typeDef : topoTypeDefs) {
            List<XSElementDeclaration> topoDecls = XMLSchemaModelUtils.getGlobalElementsByType(this.model, typeDef);
            for (XSElementDeclaration topoDecl : topoDecls) {
                Assert.assertTrue((boolean)topoElems.contains(topoDecl), (String)ErrorMessage.format("SubstitutionError", new QName(topoDecl.getNamespace(), topoDecl.getName()), "gml:AbstractTopology"));
            }
        }
    }

    @Test
    public void validateImplicitTopologyProperty() {
        XSElementDeclaration topology = this.model.getElementDeclaration("AbstractTopology", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> topoProps = XMLSchemaModelUtils.getImplicitProperties(this.model, topology);
        for (XSElementDeclaration prop : topoProps) {
            XSComplexTypeDefinition typeDef = (XSComplexTypeDefinition)prop.getTypeDefinition();
            ETSAssert.assertValidPropertyType(this.model, typeDef, null);
        }
    }
}

