/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.data.spatial.GeometryAssert;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CompositeCurveTests
extends DataFixture {
    NodeList curveNodes;
    List<QName> curveElems = new ArrayList<QName>();

    @BeforeClass(alwaysRun=true)
    public void findCompositeCurves() {
        StreamSource data = new StreamSource(this.dataFile);
        this.curveElems.add(new QName("http://www.opengis.net/gml/3.2", "CompositeCurve"));
        String xpath = "//gml:CompositeCurve";
        try {
            this.curveNodes = (NodeList)XMLUtils.evaluateXPath(data, xpath, null, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        Assert.assertFalse((this.curveNodes.getLength() == 0 ? 1 : 0) != 0, (String)"No gml:CompositeCurve elements were found.");
    }

    @Test(description="urn:iso:std:iso:19136:clause:11.2.2.2")
    public void compositeCurveComponentsAreConnected() {
        for (int i = 0; i < this.curveNodes.getLength(); ++i) {
            Element curveElem = (Element)this.curveNodes.item(i);
            GmlUtils.findCRSReference((Element)curveElem);
            GeometryAssert.assertCurveComponentsAreConnected(curveElem);
        }
    }
}

