/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.general;

import java.util.List;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.GMLObjectTypeFilter;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.testng.annotations.Test;

public class ComplexPropertyTests
extends SchemaModelFixture {
    @Test
    public void validateMetadataProperties() {
        XSTypeDefinition metadataPropType = this.model.getTypeDefinition("AbstractMetadataPropertyType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> metaPropTypes = XMLSchemaModelUtils.getGlobalElementsByType(this.model, metadataPropType);
        metaPropTypes.addAll(XMLSchemaModelUtils.getLocalElementsByType(this.model, metadataPropType, new GMLObjectTypeFilter()));
        for (XSElementDeclaration metaDataProp : metaPropTypes) {
            XSComplexTypeDefinition typeDef = (XSComplexTypeDefinition)metaDataProp.getTypeDefinition();
            ETSAssert.assertValidPropertyType(this.model, typeDef, null);
        }
    }

    @Test
    public void validateMembersOfGmlObjectCollection() {
        XSTypeDefinition memberPropType = this.model.getTypeDefinition("AbstractMemberType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> memberProps = XMLSchemaModelUtils.getGlobalElementsByType(this.model, memberPropType);
        memberProps.addAll(XMLSchemaModelUtils.getLocalElementsByType(this.model, memberPropType, null));
        XSElementDeclaration gmlObj = this.model.getElementDeclaration("AbstractGML", "http://www.opengis.net/gml/3.2");
        for (XSElementDeclaration memberProp : memberProps) {
            XSComplexTypeDefinition typeDef = (XSComplexTypeDefinition)memberProp.getTypeDefinition();
            ETSAssert.assertValidPropertyType(this.model, typeDef, gmlObj);
        }
    }
}

