/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.recommendations;

import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Set;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LexicalConventionTests
extends SchemaModelFixture {
    @Test
    public void verifyObjectNameIsUpperCamelCase() {
        ValidationErrorHandler errCollector = new ValidationErrorHandler();
        for (XSElementDeclaration gmlObject : this.gmlObjects) {
            String localName = gmlObject.getName();
            if (this.isUpperCamelCase(localName)) continue;
            errCollector.addError(ErrorSeverity.WARNING, ErrorMessage.format("NotUCCName", gmlObject.getNamespace(), localName), null);
        }
        Assert.assertFalse((boolean)errCollector.errorsDetected(), (String)errCollector.toString());
    }

    @Test
    public void verifyObjectPropertyNameIsLowerCamelCase() {
        ValidationErrorHandler errCollector = new ValidationErrorHandler();
        for (XSElementDeclaration gmlObject : this.gmlObjects) {
            XSComplexTypeDefinition typeDef = (XSComplexTypeDefinition)gmlObject.getTypeDefinition();
            List<XSElementDeclaration> elemDecls = XMLSchemaModelUtils.getAllElementsInParticle(typeDef.getParticle());
            for (XSElementDeclaration elem : elemDecls) {
                String localName = elem.getName();
                if (!this.isLowerCamelCase(localName)) {
                    errCollector.addError(ErrorSeverity.WARNING, ErrorMessage.format("NotLCCName", elem.getNamespace(), localName), null);
                }
                if (!elem.getAbstract() || localName.startsWith("abstract")) continue;
                errCollector.addError(ErrorSeverity.WARNING, ErrorMessage.format("NotAbstractName", "abstract", elem.getNamespace(), localName), null);
            }
        }
        Assert.assertFalse((boolean)errCollector.errorsDetected(), (String)errCollector.toString());
    }

    @Test
    public void verifyAbstractObjectName() {
        ValidationErrorHandler errCollector = new ValidationErrorHandler();
        for (XSElementDeclaration gmlObject : this.gmlObjects) {
            String localName = gmlObject.getName();
            if (!gmlObject.getAbstract() || localName.startsWith("Abstract")) continue;
            errCollector.addError(ErrorSeverity.WARNING, ErrorMessage.format("NotAbstractName", "Abstract", gmlObject.getNamespace(), localName), null);
        }
        Assert.assertFalse((boolean)errCollector.errorsDetected(), (String)errCollector.toString());
    }

    @Test
    public void verifyComplexTypeName() {
        ValidationErrorHandler errCollector = new ValidationErrorHandler();
        Set<XSComplexTypeDefinition> typeDefs = XMLSchemaModelUtils.getGlobalComplexTypeDefinitions(this.model);
        for (XSComplexTypeDefinition type : typeDefs) {
            String localName = type.getName();
            if (!this.isUpperCamelCase(localName)) {
                errCollector.addError(ErrorSeverity.WARNING, ErrorMessage.format("NotUCCName", type.getNamespace(), localName), null);
            }
            if (!localName.endsWith("Type")) {
                errCollector.addError(ErrorSeverity.WARNING, ErrorMessage.format("MissingTypeSuffix", type.getNamespace(), localName), null);
            }
            if (!type.getAbstract() || localName.startsWith("Abstract")) continue;
            errCollector.addError(ErrorSeverity.WARNING, ErrorMessage.format("NotAbstractName", "Abstract", type.getNamespace(), localName), null);
        }
        Assert.assertFalse((boolean)errCollector.errorsDetected(), (String)errCollector.toString());
    }

    boolean isUpperCamelCase(String localName) {
        boolean isUpperCamelCase = true;
        StringCharacterIterator itr = new StringCharacterIterator(localName);
        if (!Character.isUpperCase(itr.first())) {
            return false;
        }
        boolean foundNonUpperCaseChar = false;
        char ch = itr.next();
        while (ch != '\uffff') {
            if (!Character.isUpperCase(ch)) {
                foundNonUpperCaseChar = true;
                break;
            }
            ch = itr.next();
        }
        if (!foundNonUpperCaseChar && localName.length() > 1) {
            isUpperCamelCase = false;
        }
        return isUpperCamelCase;
    }

    boolean isLowerCamelCase(String localName) {
        return Character.isLowerCase(localName.charAt(0));
    }
}

