/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136;

import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.executors.testng.TestNGExecutor;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.iso19136.TestRunArg;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.w3c.dom.Document;

public class TestNGController
implements TestSuiteController {
    public static final String TE_BASE = "TE_BASE";
    private TestRunExecutor executor;
    private Properties etsProperties = new Properties();

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        File xmlArgs = null;
        if (args.length > 0) {
            xmlArgs = args[0].startsWith("file:") ? new File(URI.create(args[0])) : new File(args[0]);
        } else {
            String homeDir = System.getProperty("user.home");
            xmlArgs = new File(homeDir, "test-run-props.xml");
        }
        if (!xmlArgs.exists()) {
            throw new IllegalArgumentException("Test run arguments not found at " + xmlArgs);
        }
        Document testRunArgs = db.parse(xmlArgs);
        TestNGController controller = new TestNGController();
        Source testResults = controller.doTestRun(testRunArgs);
        System.out.println("Test results: " + testResults.getSystemId());
    }

    public TestNGController() {
        this(new File(System.getProperty("user.home")).toURI().toString());
    }

    public TestNGController(String outputDir) {
        InputStream is = this.getClass().getResourceAsStream("ets.properties");
        try {
            this.etsProperties.load(is);
        }
        catch (IOException ex) {
            TestSuiteLogger.log(Level.WARNING, "Unable to load ets.properties. " + ex.getMessage());
        }
        URL tngSuite = TestNGController.class.getResource("testng.xml");
        File resultsDir = new File(URI.create(outputDir));
        TestSuiteLogger.log(Level.CONFIG, "Using TestNG config: " + tngSuite);
        TestSuiteLogger.log(Level.CONFIG, "Using outputDirPath: " + resultsDir.getAbsolutePath());
        this.executor = new TestNGExecutor(tngSuite.toString(), resultsDir.getAbsolutePath(), false);
    }

    public String getCode() {
        return this.etsProperties.getProperty("ets-code");
    }

    public String getVersion() {
        return this.etsProperties.getProperty("ets-version");
    }

    public String getTitle() {
        return this.etsProperties.getProperty("ets-title");
    }

    public Source doTestRun(Document testRunArgs) throws Exception {
        this.validateTestRunArgs(testRunArgs);
        return this.executor.execute(testRunArgs);
    }

    void validateTestRunArgs(Document testRunArgs) throws Exception {
        if (null == testRunArgs || testRunArgs.getElementsByTagName("entry").getLength() == 0) {
            throw new Exception("No test run arguments were supplied.");
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        Boolean hasIUTKey = (Boolean)xpath.evaluate(String.format("//entry[@key='%s']", new Object[]{TestRunArg.IUT}), testRunArgs, XPathConstants.BOOLEAN);
        Boolean hasSchemaKey = (Boolean)xpath.evaluate(String.format("//entry[@key='%s']", new Object[]{TestRunArg.XSD}), testRunArgs, XPathConstants.BOOLEAN);
        Boolean hasDataKey = (Boolean)xpath.evaluate(String.format("//entry[@key='%s']", new Object[]{TestRunArg.GML}), testRunArgs, XPathConstants.BOOLEAN);
        if (!(hasSchemaKey.booleanValue() || hasDataKey.booleanValue() || hasIUTKey.booleanValue())) {
            throw new Exception(String.format("Missing argument: At least one of '%s', '%s', or '%s' must be present.", new Object[]{TestRunArg.XSD, TestRunArg.GML, TestRunArg.IUT}));
        }
    }
}

