/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.ImmutableEnvelope;
import org.geotoolkit.referencing.CRS;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.data.spatial.GeometryAssert;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PointTests
extends DataFixture {
    NodeList points;
    List<QName> pointElems = new ArrayList<QName>();

    @BeforeClass
    public void findPoints() {
        StreamSource data = new StreamSource(this.dataFile);
        this.pointElems.add(new QName("http://www.opengis.net/gml/3.2", "Point"));
        if (null != this.model) {
            XSElementDeclaration gmlPoint = this.model.getElementDeclaration("Point", "http://www.opengis.net/gml/3.2");
            List<XSElementDeclaration> pointDecls = XMLSchemaModelUtils.getElementsByAffiliation(this.model, gmlPoint);
            for (XSElementDeclaration decl : pointDecls) {
                this.pointElems.add(new QName(decl.getNamespace(), decl.getName()));
            }
        }
        HashMap<String, String> namespaceBindings = new HashMap<String, String>();
        String xpath = this.generateXPathExpression(this.pointElems, namespaceBindings);
        try {
            this.points = (NodeList)XMLUtils.evaluateXPath(data, xpath, namespaceBindings, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        Assert.assertFalse((this.points.getLength() == 0 ? 1 : 0) != 0, (String)"gml:Point elements not found.");
    }

    @Test(description="urn:iso:std:iso:19136:clause:9.10,10.1.3.2")
    public void pointHasValidCRS() {
        for (int i = 0; i < this.points.getLength(); ++i) {
            Element point = (Element)this.points.item(i);
            GeometryAssert.assertValidCRS(point);
        }
    }

    @Test(description="urn:iso:std:iso:19107:clause:6.2.2.10")
    public void pointHasValidPosition() {
        for (int i = 0; i < this.points.getLength(); ++i) {
            Element point = (Element)this.points.item(i);
            DirectPosition dpos = null;
            try {
                dpos = this.createDirectPosition(point);
            }
            catch (IndexOutOfBoundsException x) {
                throw new AssertionError((Object)ErrorMessage.format("CoordinateDimensionErr", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), GmlUtils.findCRSReference((Element)point)));
            }
            Assert.assertEquals((int)dpos.getDimension(), (int)dpos.getCoordinateReferenceSystem().getCoordinateSystem().getDimension(), (String)ErrorMessage.format("CoordinateDimensionErr", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), GmlUtils.findCRSReference((Element)point)));
            ImmutableEnvelope validArea = new ImmutableEnvelope(Envelopes.getDomainOfValidity((CoordinateReferenceSystem)dpos.getCoordinateReferenceSystem()));
            Assert.assertTrue((boolean)validArea.contains(dpos), (String)String.format("%s[@gml:id='%s'] is not within CRS area of use: %s.", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), validArea.toString()));
        }
    }

    DirectPosition createDirectPosition(Element point) {
        NodeList posList = point.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "pos");
        if (posList.getLength() != 1) {
            throw new IllegalArgumentException("Expected point geometry containing exactly 1 gml:pos element; received " + point.getNodeName());
        }
        String srsName = GmlUtils.findCRSReference((Element)point);
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)srsName);
        }
        catch (FactoryException fex) {
            TestSuiteLogger.log(Level.WARNING, String.format("Unknown srsName found in %s[@gml:id='%s']: %s", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), srsName), (Exception)((Object)fex));
        }
        GeneralDirectPosition dpos = new GeneralDirectPosition(crs);
        Element posElem = (Element)posList.item(0);
        String[] coordTuple = posElem.getTextContent().trim().split("\\s+");
        for (int i = 0; i < coordTuple.length; ++i) {
            double val = Double.parseDouble(coordTuple[i]);
            dpos.setOrdinate(i, val);
        }
        return dpos;
    }
}

