/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.data.spatial.GeometryAssert;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SurfaceTests
extends DataFixture {
    NodeList surfaceNodes;
    List<QName> surfaceElems = new ArrayList<QName>();

    @BeforeClass(alwaysRun=true)
    public void findSurfaces() {
        StreamSource data = new StreamSource(this.dataFile);
        if (null != this.model) {
            XSElementDeclaration gmlSurface = this.model.getElementDeclaration("AbstractSurface", "http://www.opengis.net/gml/3.2");
            List<XSElementDeclaration> surfaceDecls = XMLSchemaModelUtils.getElementsByAffiliation(this.model, gmlSurface);
            for (XSElementDeclaration decl : surfaceDecls) {
                this.surfaceElems.add(new QName(decl.getNamespace(), decl.getName()));
            }
        }
        HashMap<String, String> namespaceBindings = new HashMap<String, String>();
        String xpath = this.generateXPathExpression(this.surfaceElems, namespaceBindings);
        try {
            this.surfaceNodes = (NodeList)XMLUtils.evaluateXPath(data, xpath, namespaceBindings, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (this.surfaceNodes.getLength() == 0) {
            throw new SkipException("No surface elements (that substitute for gml:Surface) were found.");
        }
    }

    @Test(description="urn:iso:std:iso:19136:clause:9.10,10.1.3.2")
    public void surfaceHasValidCRS() {
        for (int i = 0; i < this.surfaceNodes.getLength(); ++i) {
            Element geom = (Element)this.surfaceNodes.item(i);
            GeometryAssert.assertValidCRS(geom);
        }
    }

    @Test(description="urn:iso:std:iso:19136:clause:10.5.5,10.5.11.1")
    public void validSurfaceBoundary() {
        for (int i = 0; i < this.surfaceNodes.getLength(); ++i) {
            Element surface = (Element)this.surfaceNodes.item(i);
            GeometryAssert.assertValidSurfaceBoundary(surface);
        }
    }

    @Test(description="urn:iso:std:iso:19136:clause:10.5.10")
    public void validSurfaceOrientation() {
        for (int i = 0; i < this.surfaceNodes.getLength(); ++i) {
            Element surface = (Element)this.surfaceNodes.item(i);
            GeometryAssert.assertValidSurfaceOrientation(surface);
        }
    }
}

