/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gmljpx20.util.jp2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import org.opengis.cite.gmljpx20.util.jp2.BitConverter;

public class StreamUtil {
    public static byte[] readBytes(InputStream s, int count) throws IOException {
        byte[] buffer = new byte[count];
        int len = s.read(buffer, 0, count);
        if (len < count) {
            StreamUtil.resizeArray(buffer, len);
        }
        return buffer;
    }

    private static byte[] readExactBytes(InputStream s, int count) throws Exception {
        byte[] buffer = new byte[count];
        int len = s.read(buffer, 0, count);
        if (len < count) {
            throw new Exception("Expected " + count + " bytes but only read " + len + " bytes.");
        }
        return buffer;
    }

    public static byte[] readToEnd(InputStream s) throws IOException {
        int len;
        int position = 0;
        byte[] buffer = new byte[512];
        while ((len = s.read(buffer, position, 512)) > 0) {
            position += len;
            if (len < 512) {
                StreamUtil.resizeArray(buffer, position);
                break;
            }
            StreamUtil.resizeArray(buffer, position + 512);
        }
        return buffer;
    }

    private static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static int readBInt32(InputStream s) throws Exception {
        byte[] buffer = StreamUtil.readExactBytes(s, 4);
        return BitConverter.toInt32(buffer, 0);
    }

    public static long readBInt64(InputStream s) throws Exception {
        byte[] buffer = StreamUtil.readExactBytes(s, 8);
        return BitConverter.toInt64(buffer, 0);
    }

    public static short readBUInt16(InputStream s) throws Exception {
        byte[] buffer = StreamUtil.readExactBytes(s, 2);
        return BitConverter.toInt16(buffer, 0);
    }

    public static long readBUInt32(InputStream s) throws Exception {
        byte[] buffer = StreamUtil.readExactBytes(s, 4);
        return BitConverter.ToUInt32(buffer, 0);
    }

    public static long readBUInt64(InputStream s) throws Exception {
        byte[] buffer = StreamUtil.readExactBytes(s, 8);
        return BitConverter.toInt64(buffer, 0);
    }
}

