/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gmljpx20.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.opengis.cite.gmljpx20.ErrorMessage;
import org.opengis.cite.gmljpx20.SuiteAttribute;
import org.opengis.cite.gmljpx20.box.Association;
import org.opengis.cite.gmljpx20.box.Box;
import org.opengis.cite.gmljpx20.box.ContigousCodestream;
import org.opengis.cite.gmljpx20.box.FileType;
import org.opengis.cite.gmljpx20.box.Label;
import org.opengis.cite.gmljpx20.box.ResourceRequirements;
import org.opengis.cite.gmljpx20.box.XMLBox;
import org.opengis.cite.gmljpx20.util.TestSuiteLogger;
import org.opengis.cite.gmljpx20.util.XMLUtils;
import org.opengis.cite.gmljpx20.util.jp2.JP2Stream;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CoreTests {
    private File jp2File;
    private boolean rootInstance = false;
    private DocumentBuilder docBuilder;

    @BeforeClass
    public void initFixture(ITestContext testContext) {
        Object testSubj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null != testSubj) {
            this.jp2File = (File)File.class.cast(testSubj);
            if (!this.jp2File.exists()) {
                throw new SkipException("File not found at " + this.jp2File.getAbsolutePath());
            }
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new SkipException(pce.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.1 and OGC 08-085r8, A.1.1")
    public void containsGmlCoverageDescriptions() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasGmlCovGridElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='GMLJP2GridCoverage']");
            boolean hasGmlCovRectifiedElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='GMLJP2RectifiedGridCoverage']");
            boolean hasGmlCovRefereanceableElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='GMLJP2ReferenceableGridCoverage']");
            if (!(hasGmlCovGridElems || hasGmlCovRectifiedElems || hasGmlCovRefereanceableElems)) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.2 and OGC 08-085r8, A.1.2")
    public void containsGmlCoverageMetadataCoherence() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            Box ContigousCodestream2 = this.findContigousCodestream(jp2s.boxes);
            if (ContigousCodestream2 == null) {
                throw new AssertionError((Object)ErrorMessage.get("XmlBoxNotFound"));
            }
            ContigousCodestream auxContigousCodestream = (ContigousCodestream)ContigousCodestream2;
            if (auxContigousCodestream != null) {
                int[] fileContigousCodestream = auxContigousCodestream.getContigousCodestreamData();
                XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
                this.assertXmlBox(xmlBox);
                Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
                String strhigh = (String)XMLUtils.evaluateXPath(doc, "//*[local-name()='GMLJP2RectifiedGridCoverage']//*[local-name()='high']/text()", null, XPathConstants.STRING);
                if (strhigh == null) {
                    throw new AssertionError((Object)ErrorMessage.get("XmlBoxNotFound"));
                }
                String[] parts = strhigh.split(" ");
                if (parts[0] + 1 == Integer.toString(fileContigousCodestream[0]) || parts[1] + 1 == Integer.toString(fileContigousCodestream[1])) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-metadata-coherence"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.3 and OGC 08-085r8, A.1.3")
    public void containsGmlcovPrecedence() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasGmlCovMetadataElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='metadata']");
            if (hasGmlCovMetadataElems) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-precedence-metadata"));
            }
            boolean hasGmlCovDomainSetElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='domainSet']");
            if (!hasGmlCovDomainSetElems) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-precedence-domainset"));
            }
            boolean hasGmlCovRangeTypeElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='rangeType']");
            if (!hasGmlCovRangeTypeElems) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-precedence-rangetype"));
            }
            List<String> A13_0 = CoreTests.findElementContains(doc.getChildNodes(), "gmlcov:metadata");
            List<String> A13_1 = CoreTests.findElementContains(doc.getChildNodes(), "gml:domainSet");
            List<String> A13_2 = CoreTests.findElementContains(doc.getChildNodes(), "gmlcov:rangeType");
            for (String A13_0_value : A13_0) {
                boolean hasCoherence1 = A13_1.contains(A13_0_value);
                if (!hasCoherence1) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-precedence-coherence1"));
                }
                boolean hasCoherence2 = A13_2.contains(A13_0_value);
                if (!hasCoherence2) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-precedence-coherence2"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.4 and OGC 08-085r8, A.1.4")
    public void containsGmlcovInsteadmetaDataProperty() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasGmlCovMetadataElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='metadataProperty']");
            if (hasGmlCovMetadataElems) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-metadata-property"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r8, A.1.5")
    public void containsGeographicGML32Features() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            boolean hasGeographicFeatures;
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean isRectifiedGrid = XMLUtils.evaluateXPath(doc, "//*[local-name()='RectifiedGrid']");
            if (!isRectifiedGrid) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-crs"));
            }
            NodeList A15 = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='AbstractGML'] | //*[local-name()='AbstractFeature'] | //*[local-name()='AbstractGeometry'] | //*[local-name()='AbstractCoverage']", null, XPathConstants.NODESET);
            boolean bl = hasGeographicFeatures = A15.getLength() > 0;
            if (hasGeographicFeatures) {
                throw new AssertionError((Object)ErrorMessage.get("gml-geographicFeatures"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.5 and OGC 08-085r8, A.1.6")
    public void containsCRSdeclaredUsingURIs() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean isRectifiedGrid = XMLUtils.evaluateXPath(doc, "//*[local-name()='RectifiedGrid']");
            if (!isRectifiedGrid) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-crs"));
            }
            NodeList A15 = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='RectifiedGrid']//@srsName", null, XPathConstants.NODESET);
            for (int a = 0; a < A15.getLength(); ++a) {
                Node nd = A15.item(a);
                boolean hasSrsName = nd.getNodeValue().contains("http");
                if (!hasSrsName) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-crs-http"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.6 and OGC 08-085r8, A.1.7")
    public void containsCRSrectifiedGridCoverage() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            boolean hasSrsName;
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean isRecifiedGrid = XMLUtils.evaluateXPath(doc, "//*[local-name()='RectifiedGrid']");
            if (!isRecifiedGrid) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-crs"));
            }
            NodeList A15_1 = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='RectifiedGrid']", null, XPathConstants.NODESET);
            NodeList A15_2 = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='RectifiedGrid'][@*[local-name()='srsName']]", null, XPathConstants.NODESET);
            boolean bl = hasSrsName = A15_1.getLength() == A15_2.getLength();
            if (!hasSrsName) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-crs-undefined"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.7 and OGC 08-085r8, A.1.8")
    public void containsGmlRangeTypeDataRecordUom() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            NodeList dataRecordElems = (NodeList)XMLUtils.evaluateXPath(doc, "//gmlcov:rangeType/swe:DataRecord", null, XPathConstants.NODESET);
            for (int i = 0; i < dataRecordElems.getLength(); ++i) {
                DeferredElementNSImpl dataRecordElem = (DeferredElementNSImpl)dataRecordElems.item(i);
                NodeList fieldElementNL = dataRecordElem.getElementsByTagNameNS("http://www.opengis.net/swe/2.0", "field");
                for (int f = 0; f < fieldElementNL.getLength(); ++f) {
                    boolean hasUom;
                    DeferredElementNSImpl fieldElement = (DeferredElementNSImpl)fieldElementNL.item(f);
                    String field = fieldElement.hasAttribute("name") ? fieldElement.getAttribute("name") : null;
                    boolean bl = hasUom = fieldElement.getElementsByTagNameNS("http://www.opengis.net/swe/2.0", "uom").getLength() > 0;
                    if (field.equals("Collection") || hasUom) continue;
                    System.out.println("FAILED!!");
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-datarecords-swe-uom"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.8 and OGC 08-085r8, A.1.9")
    public void containsUomByReference() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            NodeList uomElements = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='uom']", null, XPathConstants.NODESET);
            for (int i = 0; i < uomElements.getLength(); ++i) {
                boolean hasAllowableUomNamespace;
                Node element = uomElements.item(i);
                String uomCode = element.getAttributes().getNamedItem("code").getTextContent();
                boolean hasHttpUom = uomCode.startsWith("http");
                boolean bl = hasAllowableUomNamespace = uomCode.startsWith("http://www.opengis.net/def/uom/") || uomCode.startsWith("https://www.opengis.net/def/uom/") || uomCode.startsWith("http://www.epsg-registry.org");
                if (hasHttpUom && !hasAllowableUomNamespace) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-uom-http"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.9 and OGC 08-085r8, A.1.10")
    public void containsGmlcovNilValues() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            NodeList nilValues = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='nilValues']", null, XPathConstants.NODESET);
            for (int i = 0; i < nilValues.getLength(); ++i) {
                Node child = nilValues.item(i);
                boolean hasValueAndReason = (Boolean)XMLUtils.evaluateXPath(child, "//*[local-name()='nilValue'][@*[local-name()='reason']]", null, XPathConstants.BOOLEAN);
                if (!hasValueAndReason) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-nil-values"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.10 and OGC 08-085r8, A.1.11")
    public void containsGmlcovNilValuesByRef() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            NodeList nilValues = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='nilValues']", null, XPathConstants.NODESET);
            for (int i = 0; i < nilValues.getLength(); ++i) {
                Node child = nilValues.item(i);
                ArrayList reasons = (ArrayList)CoreTests.getNodeAttributeValueArray(child, "//*[local-name()='nilValue']", "reason");
                for (String reason : reasons) {
                    if (!reason.contains("http")) {
                        throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-nil-values-byref-http"));
                    }
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.11 and OGC 08-085r8, A.1.12")
    public void containsGmlcovCoverageCollectionContainer() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasGmlCovCollectionElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='GMLJP2GridCoverage']");
            if (hasGmlCovCollectionElems) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-coverage-collection"));
            }
            String[] elements = new String[]{"gmljp2:GMLJP2CoverageCollection", "gml:domainSet", "gml:rangeSet", "gmlcov:rangeType"};
            boolean hasCoverageElement = CoreTests.findElementsArray(doc.getChildNodes(), elements);
            if (hasCoverageElement) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-coverage-collection-element"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.12 and OGC 08-085r8, A.1.13")
    public void containsGmlcovCoverageContainer() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            String[] elements = new String[]{"gmlcov:AbstractCoverageType", "gmljp2:featureMembers"};
            boolean hasCoverageContainerElement = CoreTests.findElementsArray(doc.getChildNodes(), elements);
            if (hasCoverageContainerElement) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-coverage-container-element"));
            }
        }
        catch (IOException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.13 and OGC 08-085r8, A.1.14")
    public void containsGmlcovMetadata() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasGmlCovMetadataElems = XMLUtils.evaluateXPath(doc, "//*[local-name()='metadata']");
            if (hasGmlCovMetadataElems) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-metadata"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.14 and OGC 08-085r8, A.1.15")
    public void containsFileFeatures() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            NodeList features = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='GMLJP2Features']", null, XPathConstants.NODESET);
            for (int i = 0; i < features.getLength(); ++i) {
                Node feature = features.item(i);
                boolean hasCommonFeatures = (Boolean)XMLUtils.evaluateXPath(feature, "//*[local-name()='GMLJP2Features']", null, XPathConstants.BOOLEAN);
                boolean hasSingleFeatures = (Boolean)XMLUtils.evaluateXPath(feature, "//*[local-name()]='feature'", null, XPathConstants.BOOLEAN);
                if (!hasCommonFeatures && !hasSingleFeatures) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-features-annotation"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.15 and OGC 08-085r8, A.1.16")
    public void containsGMLJP2annotation() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            NodeList annotations = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='annotation']", null, XPathConstants.NODESET);
            for (int i = 0; i < annotations.getLength(); ++i) {
                boolean hasGmlJp2Annotation;
                Node annotation = annotations.item(i);
                boolean bl = hasGmlJp2Annotation = annotation.getPrefix() != "gmljp2";
                if (!hasGmlJp2Annotation) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-annotation-container"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.16 and OGC 08-085r8, A.1.17")
    public void containsGMLJP2fileStyle() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            NodeList annotations = (NodeList)XMLUtils.evaluateXPath(doc, "//*[local-name()='style']", null, XPathConstants.NODESET);
            for (int i = 0; i < annotations.getLength(); ++i) {
                boolean hasGmlJp2Annotation;
                Node annotation = annotations.item(i);
                boolean bl = hasGmlJp2Annotation = annotation.getPrefix() != "gmljp2";
                if (!hasGmlJp2Annotation) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-style-container"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.17 and OGC 08-085r8, A.1.18")
    public void containsGMLJP2filenameCodestream() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasGmlJp2fileName = XMLUtils.evaluateXPath(doc, "//gml:fileName");
            if (!hasGmlJp2fileName) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-filename-codestream"));
            }
            List<String> A117 = CoreTests.getNodeValueArray(doc, "//gml:fileName");
            boolean hasFilenameCodestream = A117.contains("gmljp2://codestream/0");
            if (!hasFilenameCodestream) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-filename-codestream"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.18 and OGC 08-085r8, A.1.19")
    public void containsXMLboxes() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            Assert.assertNotNull(xmlBox, ErrorMessage.get("XmlBoxNotFound"));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.19 and OGC 08-085r8, A.1.20")
    public void containsGMLJP2fileXMLSignaledCorrectly() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            Box fileType = this.findFileType(jp2s.boxes);
            if (fileType == null) {
                throw new AssertionError((Object)ErrorMessage.get("FileTypeNotFound"));
            }
            FileType auxFileType = (FileType)fileType;
            String fileTypeData = auxFileType.getFileTypeData();
            boolean hasFilenameCodestream = fileTypeData.contains("jpx\n");
            if (hasFilenameCodestream) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-xml-not-signalled-correctly"));
            }
            Box resourceRequirements = this.findResourceRequirements(jp2s.boxes);
            if (resourceRequirements == null) {
                throw new AssertionError((Object)ErrorMessage.get("ResourceRequirementsNotFound"));
            }
            ResourceRequirements rreq = (ResourceRequirements)resourceRequirements;
            int A119_2 = CoreTests.verifyBytes(rreq.getRreqData());
            if (A119_2 != 67) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmlcov-filename-codestream"));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.20 and OGC 08-085r8, A.1.21")
    public void containsGMLJP2fileJPXJP2Compatible() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            Box fileType = this.findFileType(jp2s.boxes);
            FileType auxFileType = (FileType)fileType;
            if (fileType == null) {
                throw new AssertionError((Object)ErrorMessage.get("FileTypeNotFound"));
            }
            String fileTypeData = auxFileType.getFileTypeData();
            if (!fileTypeData.contains("jpx")) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-jpx-compatibility"));
            }
            if (!fileTypeData.contains("jp2")) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-jp2-compatibility"));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.21 and OGC 08-085r8, A.1.22")
    public void containsGMLJP2fileJp2OuterBox() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            boolean hasGMLdata = this.existsGMLData(jp2s.boxes);
            if (!hasGMLdata) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-gmldata-exists"));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.22 and OGC 08-085r8, A.1.23")
    public void containsGMLJP2fileJp2OtherOuterBox() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            boolean hasTestStructure = this.testStructureXMLBox(jp2s.boxes);
            if (!hasTestStructure) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-test-structure-xmlbox"));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.23 and OGC 08-085r8, A.1.24")
    public void containsFileSchemaLocation() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasSchemaLocation = XMLUtils.evaluateXPath(doc, "//@*[local-name()='schemaLocation']");
            if (!hasSchemaLocation) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-schema-location"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.24 and OGC 08-085r8, A.1.25")
    public void containsFileExternalReferences() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasSchemaLocation = XMLUtils.evaluateXPath(doc, "//@*[local-name()='schemaLocation']");
            if (!hasSchemaLocation) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-schema-location"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.25 and OGC 08-085r8, A.1.26")
    public void containsFileInternalReferences() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            boolean hasSchemaLocation = XMLUtils.evaluateXPath(doc, "//@*[local-name()='schemaLocation']");
            if (!hasSchemaLocation) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-schema-location"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Test(description="OGC 08-085r8, A.1.27")
    public void containsGMLJP2ExternalRefToXMLBox() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            boolean hasSchemaLocation;
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            List<String> A127 = CoreTests.getNodeValueArray(doc, "//@*[local-name()='schemaLocation']");
            boolean bl = hasSchemaLocation = !A127.isEmpty();
            if (hasSchemaLocation) {
                boolean hasRefToHttp;
                boolean bl2 = hasRefToHttp = A127.stream().filter(e -> e.contains("http")).count() > 0L;
                if (!hasRefToHttp) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-internal-ref-to-xml-box"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e2) {
            throw new AssertionError((Object)e2.getMessage());
        }
    }

    @Test(description="OGC 08-085r8, A.1.28")
    public void containsGMLJP2fileInternalRef() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            boolean hasGmlFeatureCollection;
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            List<String> A126 = CoreTests.getNodeAttributeValueArray(doc, "//*[local-name()='feature']/*", "xsi:schemaLocation");
            boolean bl = hasGmlFeatureCollection = !A126.isEmpty();
            if (hasGmlFeatureCollection) {
                boolean hasFileInternalRefToXmlBox;
                boolean bl2 = hasFileInternalRefToXmlBox = A126.stream().filter(e -> e.contains("gmljp2://")).count() > 0L;
                if (!hasFileInternalRefToXmlBox) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-internal-references"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e2) {
            throw new AssertionError((Object)e2.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.26 and OGC 08-085r8, A.1.29")
    public void containsGMLJP2fileInternalRefToXMLBox() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            boolean hasGmlFeatureCollection;
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            List<String> A126 = CoreTests.getNodeAttributeValueArray(doc, "//*[local-name()='feature']/*", "xsi:schemaLocation");
            boolean bl = hasGmlFeatureCollection = !A126.isEmpty();
            if (hasGmlFeatureCollection) {
                boolean hasFileInternalRefToXmlBox;
                boolean bl2 = hasFileInternalRefToXmlBox = A126.stream().filter(e -> e.contains("gmljp2://xml")).count() > 0L;
                if (!hasFileInternalRefToXmlBox) {
                    throw new AssertionError((Object)ErrorMessage.get("gmljp2-internal-ref-to-xml-box"));
                }
            }
        }
        catch (IOException | XPathExpressionException | SAXException e2) {
            throw new AssertionError((Object)e2.getMessage());
        }
    }

    @Test(description="OGC 08-085r4, A.1.27 and OGC 08-085r8, A.1.30")
    public void containsInternalRefToCodestream() {
        try (FileInputStream inStream = new FileInputStream(this.jp2File);){
            JP2Stream jp2s = new JP2Stream(inStream);
            XMLBox xmlBox = this.findXMLbox(jp2s.boxes);
            this.assertXmlBox(xmlBox);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlBox.getXmldata().trim())));
            List<String> A127 = CoreTests.getNodeValueArray(doc, "//*[local-name()='fileName']");
            boolean hasGMLJP2InternalRefToCodestream = A127.contains("//*[local-name()='fileName']");
            if (hasGMLJP2InternalRefToCodestream) {
                throw new AssertionError((Object)ErrorMessage.get("gmljp2-internal-ref-to-codestream"));
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    private XMLBox findXMLbox(List<Box> boxes) {
        for (Box auxBox : boxes) {
            if (auxBox instanceof Association) {
                XMLBox xmlBox = this.findXMLbox(((Association)auxBox).getBoxes());
                if (xmlBox == null) continue;
                return xmlBox;
            }
            if (auxBox instanceof Label) {
                Label auxLabel = (Label)auxBox;
                TestSuiteLogger.log(Level.FINE, auxLabel.getLabel());
                if (!auxLabel.getLabel().contains("gml.root-instance")) continue;
                this.rootInstance = true;
                continue;
            }
            if (!(auxBox instanceof XMLBox) || !this.rootInstance) continue;
            return (XMLBox)auxBox;
        }
        return null;
    }

    private Box findContigousCodestream(List<Box> boxes) {
        for (Box auxBox : boxes) {
            if (!(auxBox instanceof ContigousCodestream)) continue;
            return auxBox;
        }
        return null;
    }

    private static List<String> findElementContains(NodeList nodeList, String element) {
        ArrayList<String> results = new ArrayList<String>();
        for (int count = 0; count < nodeList.getLength(); ++count) {
            Node tempNode = nodeList.item(count);
            if (tempNode.getNodeType() != 1 || !tempNode.hasAttributes()) continue;
            NamedNodeMap nodeMap = tempNode.getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node node = nodeMap.item(i);
                if (!node.getNodeName().contains(element)) continue;
                NodeList childrenNodes = node.getChildNodes();
                for (int d = 0; d < childrenNodes.getLength(); ++d) {
                    results.add(childrenNodes.item(d).toString());
                }
            }
        }
        return results;
    }

    private static List<String> getNodeAttributeValueArray(Node doc, String xpathExpression, String attribute) throws XPathExpressionException {
        NodeList resultNodeList = (NodeList)XMLUtils.evaluateXPath(doc, xpathExpression, null, XPathConstants.NODESET);
        ArrayList<String> results = new ArrayList<String>();
        for (int index = 0; index < resultNodeList.getLength(); ++index) {
            Node node = resultNodeList.item(index);
            String value = ((Element)node).getAttribute(attribute);
            results.add(value);
        }
        return results;
    }

    private static boolean findElementsArray(NodeList nodeList, String[] elements) {
        boolean[] nodeExists = new boolean[elements.length];
        nodeExists[0] = false;
        for (int count = 0; count < nodeList.getLength(); ++count) {
            Node tempNode = nodeList.item(count);
            if (tempNode.getNodeType() != 1 || !tempNode.hasAttributes()) continue;
            NamedNodeMap nodeMap = tempNode.getAttributes();
            String mainNode = elements[0];
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node node = nodeMap.item(i);
                if (!node.getNodeName().contains(mainNode)) continue;
                nodeExists[0] = true;
                NodeList childrenNodes = node.getChildNodes();
                for (int n = 1; n < elements.length; ++n) {
                    nodeExists[n] = false;
                    for (int d = 0; d < childrenNodes.getLength(); ++d) {
                        if (childrenNodes.item(d).toString() != elements[n]) continue;
                        nodeExists[n] = true;
                    }
                }
            }
        }
        if (!nodeExists[0]) {
            return false;
        }
        boolean allTrue = true;
        for (int d = 1; d < nodeExists.length; ++d) {
            if (nodeExists[d]) continue;
            allTrue = false;
        }
        return allTrue;
    }

    private static List<String> getNodeValueArray(Node doc, String xpathExpression) throws XPathExpressionException {
        NodeList resultNodeList = (NodeList)XMLUtils.evaluateXPath(doc, xpathExpression, null, XPathConstants.NODESET);
        ArrayList<String> results = new ArrayList<String>();
        for (int index = 0; index < resultNodeList.getLength(); ++index) {
            Node node = resultNodeList.item(index);
            String value = node.getTextContent();
            results.add(value);
        }
        return results;
    }

    private Box findFileType(List<Box> boxes) {
        for (Box auxBox : boxes) {
            if (auxBox instanceof Association) {
                Box box = this.findFileType(((Association)auxBox).getBoxes());
                if (box == null) continue;
                return box;
            }
            if (!(auxBox instanceof FileType)) continue;
            return auxBox;
        }
        return null;
    }

    private Box findResourceRequirements(List<Box> boxes) {
        for (Box auxBox : boxes) {
            if (!(auxBox instanceof ResourceRequirements)) continue;
            return auxBox;
        }
        return null;
    }

    private static int verifyBytes(byte[] req) {
        int position = 0;
        int valorFinal = 0;
        if (req[0] != 0) {
            int maskLength = req[position];
            position += maskLength;
            int fuam = 0;
            for (int a = 0; a < maskLength; ++a) {
                fuam += req[position + a];
                ++position;
            }
            int dcm = 0;
            for (int a = 0; a < maskLength; ++a) {
                dcm += req[position + a];
                ++position;
            }
            int nsf = req[position] + req[position + 1];
            position += 2;
            int[] sfi = new int[nsf];
            int[] smi = new int[nsf];
            for (int a = 0; a < nsf; ++a) {
                sfi[a] = req[position] + req[position + 1];
                position += 2;
                for (int b = 0; b < maskLength; ++b) {
                    int n = a;
                    smi[n] = smi[n] + req[position + b];
                    ++position;
                }
            }
            valorFinal = sfi[1];
        }
        return valorFinal;
    }

    private boolean existsGMLData(List<Box> boxes) {
        boolean existsGMLData = false;
        for (Box auxBox : boxes) {
            if (!(auxBox instanceof Association)) continue;
            for (Box auxBox2 : ((Association)auxBox).getBoxes()) {
                Label auxLabel;
                if (!(auxBox2 instanceof Label) || !(auxLabel = (Label)auxBox2).getLabel().contains("gml.data")) continue;
                existsGMLData = true;
            }
        }
        return existsGMLData;
    }

    private boolean testStructureXMLBox(List<Box> boxes) {
        boolean structAssoc = false;
        boolean structLabel = false;
        for (Box auxBox : boxes) {
            if (!(auxBox instanceof Association)) continue;
            structAssoc = true;
            for (Box auxBox2 : ((Association)auxBox).getBoxes()) {
                if (!(auxBox2 instanceof Label)) continue;
                structLabel = true;
            }
        }
        return structAssoc && structLabel;
    }

    private void assertXmlBox(XMLBox xmlBox) {
        if (xmlBox == null) {
            throw new AssertionError((Object)ErrorMessage.get("XmlBoxNotFound"));
        }
    }
}

