/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gmljpx20.util.jp2;

import java.io.InputStream;
import org.opengis.cite.gmljpx20.box.Association;
import org.opengis.cite.gmljpx20.box.Box;
import org.opengis.cite.gmljpx20.box.ContigousCodestream;
import org.opengis.cite.gmljpx20.box.FileType;
import org.opengis.cite.gmljpx20.box.Label;
import org.opengis.cite.gmljpx20.box.ResourceRequirements;
import org.opengis.cite.gmljpx20.box.UnsupportedBox;
import org.opengis.cite.gmljpx20.box.XMLBox;
import org.opengis.cite.gmljpx20.util.jp2.StreamUtil;

public class BoxReader {
    public static Box readFromStream(InputStream source) throws Exception {
        long length = StreamUtil.readBUInt32(source);
        long extendedLength = 0L;
        if (length == 1L) {
            extendedLength = StreamUtil.readBUInt64(source);
        }
        int type = StreamUtil.readBInt32(source);
        switch (type) {
            case 1785737827: {
                return new ContigousCodestream(source, (int)length, extendedLength);
            }
            case 1718909296: {
                return new FileType(source, (int)length, extendedLength);
            }
            case 1634955107: {
                return new Association(source, (int)length);
            }
            case 2020437024: {
                return new XMLBox(source, (int)length, extendedLength);
            }
            case 1818389536: {
                return new Label(source, (int)length, extendedLength);
            }
            case 1920099697: {
                return new ResourceRequirements(source, (int)length, extendedLength);
            }
        }
        return new UnsupportedBox(source, (int)length, extendedLength);
    }
}

