/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trans.XPathException;

public class FunctionLibraryList
implements FunctionLibrary,
XQueryFunctionBinder {
    public List libraryList = new ArrayList(8);

    public int addFunctionLibrary(FunctionLibrary lib) {
        this.libraryList.add(lib);
        return this.libraryList.size() - 1;
    }

    public FunctionLibrary get(int n) {
        return (FunctionLibrary)this.libraryList.get(n);
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        for (FunctionLibrary lib : this.libraryList) {
            if (!lib.isAvailable(functionName, arity)) continue;
            return true;
        }
        return false;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        for (FunctionLibrary lib : this.libraryList) {
            Expression func = lib.bind(functionName, staticArgs, env);
            if (func == null) continue;
            return func;
        }
        return null;
    }

    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        for (FunctionLibrary lib : this.libraryList) {
            XQueryFunction func;
            if (!(lib instanceof XQueryFunctionBinder) || (func = ((XQueryFunctionBinder)lib).getDeclaration(functionName, staticArgs)) == null) continue;
            return func;
        }
        return null;
    }

    public List getLibraryList() {
        return this.libraryList;
    }

    public FunctionLibrary copy() {
        FunctionLibraryList fll = new FunctionLibraryList();
        fll.libraryList = new ArrayList(this.libraryList.size());
        for (int i = 0; i < this.libraryList.size(); ++i) {
            fll.libraryList.add(((FunctionLibrary)this.libraryList.get(i)).copy());
        }
        return fll;
    }
}

