/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gmljpx20.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.gmljpx20.ReusableEntityFilter;
import org.w3c.dom.Document;

public class ClientUtils {
    public static Client buildClient() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        config.getProperties().put("com.sun.jersey.client.property.connectTimeout", 10000);
        Client client = Client.create((ClientConfig)config);
        client.addFilter((ClientFilter)new ReusableEntityFilter());
        client.addFilter((ClientFilter)new LoggingFilter());
        return client;
    }

    public static Client buildClientWithProxy(final String proxyHost, final int proxyPort) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){
            SocketAddress addr;
            Proxy proxy;
            {
                this.addr = new InetSocketAddress(proxyHost, proxyPort);
                this.proxy = new Proxy(Proxy.Type.HTTP, this.addr);
            }

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                return (HttpURLConnection)url.openConnection(this.proxy);
            }
        }), (ClientConfig)config);
        client.addFilter((ClientFilter)new LoggingFilter());
        return client;
    }

    public static ClientRequest buildGetRequest(URI endpoint, Map<String, String> qryParams, MediaType ... mediaTypes) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)endpoint);
        if (null != qryParams) {
            for (Map.Entry<String, String> param : qryParams.entrySet()) {
                uriBuilder.queryParam(param.getKey(), new Object[]{param.getValue()});
            }
        }
        URI uri = uriBuilder.build(new Object[0]);
        ClientRequest.Builder reqBuilder = ClientRequest.create();
        reqBuilder = null == mediaTypes || mediaTypes.length == 0 ? (ClientRequest.Builder)reqBuilder.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}) : (ClientRequest.Builder)reqBuilder.accept(mediaTypes);
        ClientRequest req = reqBuilder.build(uri, "GET");
        return req;
    }

    public static MediaType removeParameters(MediaType mediaType) {
        return new MediaType(mediaType.getType(), mediaType.getSubtype());
    }

    public static Source getResponseEntityAsSource(ClientResponse response, String targetURI) {
        Source source = (Source)response.getEntity(DOMSource.class);
        if (null != targetURI && !targetURI.isEmpty()) {
            source.setSystemId(targetURI);
        }
        if (response.getEntityInputStream().markSupported()) {
            try {
                response.getEntityInputStream().reset();
            }
            catch (IOException ex) {
                Logger.getLogger(ClientUtils.class.getName()).log(Level.WARNING, "Failed to reset response entity.", ex);
            }
        }
        return source;
    }

    public static Document getResponseEntityAsDocument(ClientResponse response, String targetURI) {
        DOMSource domSource = (DOMSource)ClientUtils.getResponseEntityAsSource(response, targetURI);
        Document entityDoc = (Document)domSource.getNode();
        entityDoc.setDocumentURI(domSource.getSystemId());
        return entityDoc;
    }
}

