/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.n3;

import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.n3.JenaURIException;
import org.apache.jena.util.FileUtils;

@Deprecated
public class IRIResolver {
    private static String globalBase;
    static final IRI cwd;
    static final IRIFactory factory;
    private final IRI base;
    private static boolean showExceptions;

    public static String resolveFileURL(String filename) throws IRIException {
        IRI r = cwd.resolve(filename);
        if (!r.getScheme().equalsIgnoreCase("file")) {
            return IRIResolver.resolveFileURL("./" + filename);
        }
        return r.toString();
    }

    public static String resolve(String relStr, String baseStr) throws JenaURIException {
        return IRIResolver.exceptions(IRIResolver.resolveIRI(relStr, baseStr)).toString();
    }

    private static IRI resolveIRI(String relStr, String baseStr) {
        IRI i = factory.create(relStr);
        if (i.isAbsolute()) {
            return cwd.create(i);
        }
        IRI base = factory.create(baseStr);
        if ("file".equalsIgnoreCase(base.getScheme())) {
            return cwd.create(base).create(i);
        }
        return base.create(i);
    }

    public IRIResolver() {
        this(null);
    }

    public IRIResolver(String baseS) {
        if (baseS == null) {
            baseS = IRIResolver.chooseBaseURI();
        }
        this.base = IRIResolver.exceptions(cwd.create(baseS));
    }

    public String getBaseIRI() {
        return this.base.toString();
    }

    public String resolve(String relURI) {
        return IRIResolver.exceptions(this.base.resolve(relURI)).toString();
    }

    private static IRI exceptions(IRI iri) {
        if (showExceptions && iri.hasViolation(false)) {
            try {
                cwd.construct(iri);
            }
            catch (IRIException e) {
                throw new JenaURIException(e);
            }
        }
        return iri;
    }

    public static void suppressExceptions() {
        IRIResolver.setShowExceptions(false);
    }

    public static void setShowExceptions(boolean state) {
        showExceptions = state;
    }

    public static String resolveGlobal(String str) {
        return IRIResolver.exceptions(cwd.resolve(str)).toString();
    }

    public static String chooseBaseURI() {
        return IRIResolver.chooseBaseURI(null);
    }

    public static String chooseBaseURI(String baseURI) {
        if (baseURI == null) {
            baseURI = "file:.";
        }
        return IRIResolver.resolveGlobal(baseURI);
    }

    static {
        IRI cwdx;
        globalBase = "http://localhost/LocalHostBase/";
        try {
            globalBase = FileUtils.toURL(".");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        factory = new IRIFactory(IRIFactory.jenaImplementation());
        factory.setSameSchemeRelativeReferences("file");
        try {
            cwdx = factory.construct(globalBase);
        }
        catch (IRIException e) {
            System.err.println("Unexpected IRIException in initializer: " + e.getMessage());
            cwdx = factory.create("file:///");
        }
        cwd = cwdx;
        showExceptions = true;
    }
}

