/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gmljpx20;

import jakarta.ws.rs.client.Client;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.cite.gmljpx20.SuiteAttribute;
import org.opengis.cite.gmljpx20.TestRunArg;
import org.opengis.cite.gmljpx20.util.ClientUtils;
import org.opengis.cite.gmljpx20.util.TestSuiteLogger;
import org.opengis.cite.gmljpx20.util.URIUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerClientComponent(suite);
    }

    public void onFinish(ISuite suite) {
    }

    void processSuiteParameters(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = (String)params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        File iutFile = null;
        try {
            iutFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)iutFile);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append('\n');
            logMsg.append(iutFile.getAbsolutePath()).append('\n');
            logMsg.append(iutFile.length() / 1024L).append(" KiB");
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), (Object)client);
        }
    }
}

