package org.opengis.cite.gmljpx20;

/**
 * Defines keys used to access localized messages for assertion errors. The messages are
 * stored in Properties files that are encoded in ISO-8859-1 (Latin-1). For some languages
 * the {@code native2ascii} tool must be used to process the files and produce escaped
 * Unicode characters.
 */
public class ErrorMessageKeys {

	/** Constant <code>NOT_SCHEMA_VALID="NotSchemaValid"</code> */
	public static final String NOT_SCHEMA_VALID = "NotSchemaValid";

	/** Constant <code>XPATH_RESULT="XPathResult"</code> */
	public static final String XPATH_RESULT = "XPathResult";

	/** Constant <code>NAMESPACE_NAME="NamespaceName"</code> */
	public static final String NAMESPACE_NAME = "NamespaceName";

	/** Constant <code>LOCAL_NAME="LocalName"</code> */
	public static final String LOCAL_NAME = "LocalName";

	/** Constant <code>XML_ERROR="XMLError"</code> */
	public static final String XML_ERROR = "XMLError";

	/** Constant <code>XPATH_ERROR="XPathError"</code> */
	public static final String XPATH_ERROR = "XPathError";

	/** Constant <code>UNEXPECTED_STATUS="UnexpectedStatus"</code> */
	public static final String UNEXPECTED_STATUS = "UnexpectedStatus";

	/** Constant <code>XML_BOX_NOT_FOUND="XmlBoxNotFound"</code> */
	public static final String XML_BOX_NOT_FOUND = "XmlBoxNotFound";

	/** Constant <code>FILETYPE_NOT_FOUND="FileTypeNotFound"</code> */
	public static final String FILETYPE_NOT_FOUND = "FileTypeNotFound";

	/**
	 * Constant
	 * <code>RESOURCE_REQUIREMENTS_NOT_FOUND="ResourceRequirementsNotFound"</code>
	 */
	public static final String RESOURCE_REQUIREMENTS_NOT_FOUND = "ResourceRequirementsNotFound";

	/** Constant <code>GMLJP2_GMLCOV="gmljp2-gmlcov"</code> */
	public static final String GMLJP2_GMLCOV = "gmljp2-gmlcov";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_METADATA_HIGH="gmljp2-gmlcov-metadata-coherence"</code>
	 */
	public static final String GMLJP2_GMLCOV_METADATA_HIGH = "gmljp2-gmlcov-metadata-coherence";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_PRECEDENCE_METADATA="gmljp2-gmlcov-precedence-metadata"</code>
	 */
	public static final String GMLJP2_GMLCOV_PRECEDENCE_METADATA = "gmljp2-gmlcov-precedence-metadata";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_PRECEDENCE_DOMAIN_SET="gmljp2-gmlcov-precedence-domainset"</code>
	 */
	public static final String GMLJP2_GMLCOV_PRECEDENCE_DOMAIN_SET = "gmljp2-gmlcov-precedence-domainset";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_PRECEDENCE_RANGE_TYPE="gmljp2-gmlcov-precedence-rangetype"</code>
	 */
	public static final String GMLJP2_GMLCOV_PRECEDENCE_RANGE_TYPE = "gmljp2-gmlcov-precedence-rangetype";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_PRECEDENCE_COHERENCE1="gmljp2-gmlcov-precedence-coherence1"</code>
	 */
	public static final String GMLJP2_GMLCOV_PRECEDENCE_COHERENCE1 = "gmljp2-gmlcov-precedence-coherence1";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_PRECEDENCE_COHERENCE2="gmljp2-gmlcov-precedence-coherence2"</code>
	 */
	public static final String GMLJP2_GMLCOV_PRECEDENCE_COHERENCE2 = "gmljp2-gmlcov-precedence-coherence2";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_INSTEAD_METADATAPROPERTY="gmljp2-gmlcov-metadata-property"</code>
	 */
	public static final String GMLJP2_GMLCOV_INSTEAD_METADATAPROPERTY = "gmljp2-gmlcov-metadata-property";

	/** Constant <code>GMLJP2_GMLCOV_CRS_RECTIFIED_GRID="gmljp2-gmlcov-crs"</code> */
	public static final String GMLJP2_GMLCOV_CRS_RECTIFIED_GRID = "gmljp2-gmlcov-crs";

	/** Constant <code>GMLJP2_GML_GEOGRAPHIC_FEATURES="gml-geographicFeatures"</code> */
	public static final String GMLJP2_GML_GEOGRAPHIC_FEATURES = "gml-geographicFeatures";

	/** Constant <code>GMLJP2_GMLCOV_CRS_HTTP="gmljp2-gmlcov-crs-http"</code> */
	public static final String GMLJP2_GMLCOV_CRS_HTTP = "gmljp2-gmlcov-crs-http";

	/** Constant <code>GMLJP2_GMLCOV_CRS_UNDEFINED="gmljp2-gmlcov-crs-undefined"</code> */
	public static final String GMLJP2_GMLCOV_CRS_UNDEFINED = "gmljp2-gmlcov-crs-undefined";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_DATARECORDS_SWEUOM="gmljp2-gmlcov-datarecords-swe-uom"</code>
	 */
	public static final String GMLJP2_GMLCOV_DATARECORDS_SWEUOM = "gmljp2-gmlcov-datarecords-swe-uom";

	/** Constant <code>GMLJP2_GMLCOV_UOM_HTTP="gmljp2-gmlcov-uom-http"</code> */
	public static final String GMLJP2_GMLCOV_UOM_HTTP = "gmljp2-gmlcov-uom-http";

	/** Constant <code>GMLJP2_GMLCOV_NIL_VALUES="gmljp2-gmlcov-nil-values"</code> */
	public static final String GMLJP2_GMLCOV_NIL_VALUES = "gmljp2-gmlcov-nil-values";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_NIL_VALUES_BY_REF_HTTP="gmljp2-gmlcov-nil-values-byref-http"</code>
	 */
	public static final String GMLJP2_GMLCOV_NIL_VALUES_BY_REF_HTTP = "gmljp2-gmlcov-nil-values-byref-http";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_COVERAGE_COLLECTION="gmljp2-gmlcov-coverage-collection"</code>
	 */
	public static final String GMLJP2_GMLCOV_COVERAGE_COLLECTION = "gmljp2-gmlcov-coverage-collection";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_COVERAGE_COLLECTION_ELEMENT="gmljp2-gmlcov-coverage-collection-eleme"{trunked}</code>
	 */
	public static final String GMLJP2_GMLCOV_COVERAGE_COLLECTION_ELEMENT = "gmljp2-gmlcov-coverage-collection-element";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_COVERAGE_CONTAINER_ELEMENT="gmljp2-gmlcov-coverage-container-elemen"{trunked}</code>
	 */
	public static final String GMLJP2_GMLCOV_COVERAGE_CONTAINER_ELEMENT = "gmljp2-gmlcov-coverage-container-element";

	/** Constant <code>GMLJP2_GMLCOV_METADATA="gmljp2-gmlcov-metadata"</code> */
	public static final String GMLJP2_GMLCOV_METADATA = "gmljp2-gmlcov-metadata";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_FEATURES_ANNOTATION="gmljp2-gmlcov-features-annotation"</code>
	 */
	public static final String GMLJP2_GMLCOV_FEATURES_ANNOTATION = "gmljp2-gmlcov-features-annotation";

	/** Constant <code>GMLJP2_ANNOTATION_CONTAINER="gmljp2-annotation-container"</code> */
	public static final String GMLJP2_ANNOTATION_CONTAINER = "gmljp2-annotation-container";

	/** Constant <code>GMLJP2_STYLE_CONTAINER="gmljp2-style-container"</code> */
	public static final String GMLJP2_STYLE_CONTAINER = "gmljp2-style-container";

	/**
	 * Constant
	 * <code>GMLJP2_GMLCOV_FILENAME_CODESTREAM="gmljp2-gmlcov-filename-codestream"</code>
	 */
	public static final String GMLJP2_GMLCOV_FILENAME_CODESTREAM = "gmljp2-gmlcov-filename-codestream";

	/**
	 * Constant
	 * <code>GMLJP2_XML_NOT_SIGNALLED_CORRECTLY="gmljp2-xml-not-signalled-correctly"</code>
	 */
	public static final String GMLJP2_XML_NOT_SIGNALLED_CORRECTLY = "gmljp2-xml-not-signalled-correctly";

	/** Constant <code>GMLJP2_JPX_COMPATILITY="gmljp2-jpx-compatibility"</code> */
	public static final String GMLJP2_JPX_COMPATILITY = "gmljp2-jpx-compatibility";

	/** Constant <code>GMLJP2_JP2_COMPATILITY="gmljp2-jp2-compatibility"</code> */
	public static final String GMLJP2_JP2_COMPATILITY = "gmljp2-jp2-compatibility";

	/** Constant <code>GMLJP2_GMLDATA_EXISTS="gmljp2-gmldata-exists"</code> */
	public static final String GMLJP2_GMLDATA_EXISTS = "gmljp2-gmldata-exists";

	/**
	 * Constant <code>GMLJP2_TEST_STRUCTURE_XMLBOX="gmljp2-test-structure-xmlbox"</code>
	 */
	public static final String GMLJP2_TEST_STRUCTURE_XMLBOX = "gmljp2-test-structure-xmlbox";

	/** Constant <code>GMLJP2_SCHEMA_LOCATION="gmljp2-schema-location"</code> */
	public static final String GMLJP2_SCHEMA_LOCATION = "gmljp2-schema-location";

	/** Constant <code>GMLJP2_EXTERNAL_REFS="gmljp2-external-references"</code> */
	public static final String GMLJP2_EXTERNAL_REFS = "gmljp2-external-references";

	/** Constant <code>GMLJP2_INTERNAL_REFERENCES="gmljp2-internal-references"</code> */
	public static final String GMLJP2_INTERNAL_REFERENCES = "gmljp2-internal-references";

	/**
	 * Constant
	 * <code>GMLJP2_INTERNAL_REF_TO_XML_BOX="gmljp2-internal-ref-to-xml-box"</code>
	 */
	public static final String GMLJP2_INTERNAL_REF_TO_XML_BOX = "gmljp2-internal-ref-to-xml-box";

	/**
	 * Constant
	 * <code>GMLJP2_INTERNAL_REF_TO_CODESTREAM="gmljp2-internal-ref-to-codestream"</code>
	 */
	public static final String GMLJP2_INTERNAL_REF_TO_CODESTREAM = "gmljp2-internal-ref-to-codestream";

}
