package org.opengis.cite.gmljpx20;

/**
 * Contains various constants pertaining to the inclusion of GML in JPEG 2000 codestreams,
 * as specified in OGC 08-085r4 and related specifications.
 *
 * @see <a href="http://docs.opengeospatial.org/is/08-085r4/08-085r4.html" target=
 * "_blank">OGC GML in JPEG 2000 (GMLJP2) Encoding Standard Part 1: Core, Version 2.0</a>
 */
public class GMLJP2 {

	/** Constant <code>LBL_GML_DATA="gml.data"</code> */
	public static final String LBL_GML_DATA = "gml.data";

	/** Constant <code>LBL_GML_ROOT="gml.root-instance"</code> */
	public static final String LBL_GML_ROOT = "gml.root-instance";

}
