/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.opengis.cite.gpkg10.CommonFixture;
import org.opengis.cite.gpkg10.ErrorMessage;
import org.opengis.cite.gpkg10.GPKG10;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SQLiteContainerTests
extends CommonFixture {
    @Test(description="See OGC 12-128r12: Requirement 1")
    public void fileHeaderString() throws IOException {
        byte[] headerString = new byte[GPKG10.SQLITE_MAGIC_HEADER.length];
        try (FileInputStream fileInputStream = new FileInputStream(this.gpkgFile);){
            fileInputStream.read(headerString);
        }
        Assert.assertTrue((boolean)Arrays.equals(headerString, GPKG10.SQLITE_MAGIC_HEADER), (String)ErrorMessage.format("InvalidHeaderString", new String(headerString, StandardCharsets.US_ASCII)));
    }

    @Test(description="See OGC 12-128r12: Requirement 2")
    public void applicationID() throws IOException {
        byte[] headerBytes = new byte[100];
        try (FileInputStream fileInputStream = new FileInputStream(this.gpkgFile);){
            fileInputStream.read(headerBytes);
        }
        byte[] appID = Arrays.copyOfRange(headerBytes, 68, 72);
        Assert.assertTrue((boolean)Arrays.equals(appID, GPKG10.APP_GP10), (String)ErrorMessage.format("UnknownApplicationId", new String(appID, StandardCharsets.US_ASCII)));
    }

    @Test(description="See OGC 12-128r12: Requirement 3")
    public void filenameExtension() {
        String fileName = this.gpkgFile.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(46));
        Assert.assertEquals((String)suffix, (String)".gpkg", (String)ErrorMessage.format("InvalidSuffix", suffix));
    }

    @Test(description="See OGC 12-128r12: Requirement 4")
    public void fileContents() {
    }

    @Test(description="See OGC 12-128r12: Requirement 6")
    public void pragmaIntegrityCheck() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA integrity_check;");){
            resultSet.next();
            Assert.assertEquals((String)resultSet.getString("integrity_check").toLowerCase(), (String)"ok", (String)ErrorMessage.format("PragmaIntegrityCheckNotOk", new Object[0]));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 7")
    public void foreignKeyCheck() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA foreign_key_check;");){
            Assert.assertTrue((!resultSet.next() ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidForeignKey", new Object[0]));
        }
    }

    /*
     * Loose catch block
     */
    @Test(description="See OGC 12-128r12: Requirement 8")
    public void sqlCheck() throws SQLException {
        try {
            Statement stmt = this.databaseConnection.createStatement();
            Throwable throwable = null;
            ResultSet result = stmt.executeQuery("SELECT * FROM sqlite_master;");
            Throwable throwable2 = null;
            if (result != null) {
                if (throwable2 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                } else {
                    result.close();
                }
            }
            return;
            {
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            AssertJUnit.fail((String)ErrorMessage.format("NoSqlAccess", new Object[0]));
            return;
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 9")
    public void sqliteOptions() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT sqlite_compileoption_used('SQLITE_OMIT_*')");){
            Assert.assertEquals((int)resultSet.getInt(1), (int)0, (String)ErrorMessage.format("SqliteOmitOptions", new Object[0]));
        }
    }
}

