/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opengis.cite.gpkg10.ColumnDefinition;
import org.opengis.cite.gpkg10.ForeignKeyDefinition;
import org.opengis.cite.gpkg10.UniqueDefinition;

public final class TableVerifier {
    private TableVerifier() {
    }

    public static void verifyTable(Connection connection, String tableName, Map<String, ColumnDefinition> expectedColumns, Set<ForeignKeyDefinition> expectedForeinKeys, Iterable<UniqueDefinition> expectedGroupUniques) throws SQLException {
        TableVerifier.verifyTableDefinition(connection, tableName);
        Set<UniqueDefinition> uniques = TableVerifier.getUniques(connection, tableName);
        TableVerifier.verifyColumns(connection, tableName, expectedColumns, uniques);
        TableVerifier.verifyForeignKeys(connection, tableName, expectedForeinKeys);
        TableVerifier.verifyGroupUniques(tableName, expectedGroupUniques, uniques);
    }

    private static void verifyTableDefinition(Connection connection, String tableName) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT sql FROM sqlite_master WHERE (type = 'table' OR type = 'view') AND tbl_name = ?;");){
            statement.setString(1, tableName);
            try (ResultSet gpkgContents = statement.executeQuery();){
                if (gpkgContents.getString("sql") == null) {
                    throw new RuntimeException(String.format("The `sql` field must include the %s table SQL Definition.", tableName));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Set<UniqueDefinition> getUniques(Connection connection, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void verifyColumns(Connection connection, String tableName, Map<String, ColumnDefinition> requiredColumns, Collection<UniqueDefinition> uniques) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet tableInfo = statement.executeQuery(String.format("PRAGMA table_info(%s);", tableName));){
            TreeMap<String, ColumnDefinition> columns = new TreeMap<String, ColumnDefinition>(String.CASE_INSENSITIVE_ORDER);
            while (tableInfo.next()) {
                String columnName = tableInfo.getString("name");
                columns.put(columnName, new ColumnDefinition(tableInfo.getString("type"), tableInfo.getBoolean("notnull"), tableInfo.getBoolean("pk"), uniques.stream().anyMatch(unique -> unique.equals(columnName)), tableInfo.getString("dflt_value")));
            }
            for (Map.Entry<String, ColumnDefinition> column : requiredColumns.entrySet()) {
                if (!columns.containsKey(column.getKey())) {
                    throw new RuntimeException(String.format("Required column: %s.%s is missing", tableName, column.getKey()));
                }
                ColumnDefinition columnDefinition = (ColumnDefinition)columns.get(column.getKey());
                if (columnDefinition == null || columnDefinition.equals(column.getValue()) && TableVerifier.checkExpressionEquivalence(connection, columnDefinition.getDefaultValue(), column.getValue().getDefaultValue())) continue;
                throw new RuntimeException(String.format("Required column %s is defined as:\n%s\nbut should be:\n%s", column.getKey(), columnDefinition.toString(), column.getValue().toString()));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean checkExpressionEquivalence(Connection connection, String expression1, String expression2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void verifyForeignKeys(Connection connection, String tableName, Set<ForeignKeyDefinition> requiredForeignKeys) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try (ResultSet fkInfo = statement.executeQuery(String.format("PRAGMA foreign_key_list(%s);", tableName));){
                LinkedList<ForeignKeyDefinition> foundForeignKeys = new LinkedList<ForeignKeyDefinition>();
                while (fkInfo.next()) {
                    foundForeignKeys.add(new ForeignKeyDefinition(fkInfo.getString("table"), fkInfo.getString("from"), fkInfo.getString("to")));
                }
                HashSet<ForeignKeyDefinition> missingKeys = new HashSet<ForeignKeyDefinition>(requiredForeignKeys);
                missingKeys.removeAll(foundForeignKeys);
                HashSet extraneousKeys = new HashSet(foundForeignKeys);
                extraneousKeys.removeAll(requiredForeignKeys);
                StringBuilder error = new StringBuilder();
                if (!missingKeys.isEmpty()) {
                    error.append(String.format("The table %s is missing the foreign key constraint(s): \n", tableName));
                    for (ForeignKeyDefinition key : missingKeys) {
                        error.append(String.format("%s.%s -> %s.%s\n", tableName, key.getFromColumnName(), key.getReferenceTableName(), key.getToColumnName()));
                    }
                }
                if (!extraneousKeys.isEmpty()) {
                    error.append(String.format("The table %s has extraneous foreign key constraint(s): \n", tableName));
                    for (ForeignKeyDefinition key : extraneousKeys) {
                        error.append(String.format("%s.%s -> %s.%s\n", tableName, key.getFromColumnName(), key.getReferenceTableName(), key.getToColumnName()));
                    }
                }
                if (error.length() != 0) {
                    throw new RuntimeException(error.toString());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void verifyGroupUniques(String tableName, Iterable<UniqueDefinition> requiredGroupUniques, Collection<UniqueDefinition> uniques) {
        for (UniqueDefinition groupUnique : requiredGroupUniques) {
            if (uniques.contains(groupUnique)) continue;
            throw new RuntimeException(String.format("The table %s is missing the column group unique constraint: (%s)", tableName, String.join((CharSequence)", ", groupUnique.getColumnNames())));
        }
    }
}

