/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.opengis.cite.gpkg10.ColumnDefinition;
import org.opengis.cite.gpkg10.CommonFixture;
import org.opengis.cite.gpkg10.ErrorMessage;
import org.opengis.cite.gpkg10.TableVerifier;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SpatialReferenceSystemsTests
extends CommonFixture {
    @Test(description="See OGC 12-128r12: Requirement 10")
    public void srsTableDefinition() throws SQLException {
        try {
            HashMap<String, ColumnDefinition> spatialReferenceSystemColumns = new HashMap<String, ColumnDefinition>();
            spatialReferenceSystemColumns.put("srs_name", new ColumnDefinition("TEXT", true, false, false, null));
            spatialReferenceSystemColumns.put("srs_id", new ColumnDefinition("INTEGER", true, true, true, null));
            spatialReferenceSystemColumns.put("organization", new ColumnDefinition("TEXT", true, false, false, null));
            spatialReferenceSystemColumns.put("organization_coordsys_id", new ColumnDefinition("INTEGER", true, false, false, null));
            spatialReferenceSystemColumns.put("definition", new ColumnDefinition("TEXT", true, false, false, null));
            spatialReferenceSystemColumns.put("description", new ColumnDefinition("TEXT", false, false, false, null));
            TableVerifier.verifyTable(this.databaseConnection, "gpkg_spatial_ref_sys", spatialReferenceSystemColumns, Collections.emptySet(), Collections.emptyList());
        }
        catch (Throwable th) {
            AssertJUnit.fail((String)ErrorMessage.format("BadSrsTableDefinition", th.getMessage()));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 11")
    public void requiredSrsEntries() throws SQLException {
        Throwable throwable;
        ResultSet srsDefaultValue;
        try (Statement statement = this.databaseConnection.createStatement();){
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE organization_coordsys_id = 4326 AND (organization = 'EPSG' OR organization = 'epsg');");
            throwable = null;
            try {
                Assert.assertTrue((boolean)srsDefaultValue.next(), (String)ErrorMessage.format("NoGeographicSrs", new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (srsDefaultValue != null) {
                    if (throwable != null) {
                        try {
                            srsDefaultValue.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        srsDefaultValue.close();
                    }
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        var2_2 = null;
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = -1 AND organization = 'NONE' AND organization_coordsys_id = -1 AND definition = 'undefined';");
            throwable = null;
            try {
                Assert.assertTrue((boolean)srsDefaultValue.next(), (String)ErrorMessage.format("NoUndefinedCartesianSrs", new Object[0]));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (srsDefaultValue != null) {
                    if (throwable != null) {
                        try {
                            srsDefaultValue.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        srsDefaultValue.close();
                    }
                }
            }
        }
        catch (Throwable srsDefaultValue2) {
            var2_2 = srsDefaultValue2;
            throw srsDefaultValue2;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable srsDefaultValue2) {
                        var2_2.addSuppressed(srsDefaultValue2);
                    }
                } else {
                    statement.close();
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        var2_2 = null;
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = 0 AND organization = 'NONE' AND organization_coordsys_id =  0 AND definition = 'undefined';");
            throwable = null;
            try {
                Assert.assertTrue((boolean)srsDefaultValue.next(), (String)ErrorMessage.format("NoUndefinedGeographicSrs", new Object[0]));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (srsDefaultValue != null) {
                    if (throwable != null) {
                        try {
                            srsDefaultValue.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        srsDefaultValue.close();
                    }
                }
            }
        }
        catch (Throwable throwable8) {
            var2_2 = throwable8;
            throw throwable8;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable9) {
                        var2_2.addSuppressed(throwable9);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 12")
    public void checkContentSrs() throws SQLException {
        String query = "SELECT DISTINCT srs_id as srsContents FROM gpkg_contents WHERE srsContents NOT IN (SELECT srs_id FROM gpkg_spatial_ref_sys);";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet srsDefined = statement.executeQuery("SELECT DISTINCT srs_id as srsContents FROM gpkg_contents WHERE srsContents NOT IN (SELECT srs_id FROM gpkg_spatial_ref_sys);");){
            LinkedList<String> invalidSrsIds = new LinkedList<String>();
            while (srsDefined.next()) {
                invalidSrsIds.add(srsDefined.getString("srsContents"));
            }
            Assert.assertTrue((boolean)invalidSrsIds.isEmpty(), (String)ErrorMessage.format("UndefinedSrs", invalidSrsIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }
}

