/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10.tiles;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.opengis.cite.gpkg10.ColumnDefinition;
import org.opengis.cite.gpkg10.CommonFixture;
import org.opengis.cite.gpkg10.ErrorMessage;
import org.opengis.cite.gpkg10.ForeignKeyDefinition;
import org.opengis.cite.gpkg10.TableVerifier;
import org.opengis.cite.gpkg10.TestRunArg;
import org.opengis.cite.gpkg10.UniqueDefinition;
import org.opengis.cite.gpkg10.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TileTests
extends CommonFixture {
    private boolean hasTileMatrixTable;
    private boolean hasTileMatrixSetTable;
    private final Collection<String> tileTableNames = new ArrayList<String>();
    private final Collection<String> contentsTileTableNames = new ArrayList<String>();
    private static final double EPSILON = 1.0E-4;
    private static final Collection<ImageReader> jpegImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/jpeg"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    private static final Collection<ImageReader> pngImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/png"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    private static final Map<String, ColumnDefinition> TileTableExpectedColumns = new HashMap<String, ColumnDefinition>();
    private static final Set<ForeignKeyDefinition> TileTableExpectedForeignKeys;
    private static final Set<UniqueDefinition> TileTableExpectedUniqueColumnGroups;

    @BeforeClass
    public void setUp() throws SQLException {
        Throwable throwable;
        ResultSet resultSet;
        this.hasTileMatrixTable = DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_tile_matrix");
        this.hasTileMatrixSetTable = DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_tile_matrix_set");
        try (Statement statement = this.databaseConnection.createStatement();){
            resultSet = statement.executeQuery("SELECT tbl_name FROM sqlite_master WHERE tbl_name NOT LIKE 'gpkg_%' AND (type = 'table' OR type = 'view');");
            throwable = null;
            try {
                while (resultSet.next()) {
                    try {
                        String tableName = resultSet.getString("tbl_name");
                        TableVerifier.verifyTable(this.databaseConnection, tableName, TileTableExpectedColumns, TileTableExpectedForeignKeys, TileTableExpectedUniqueColumnGroups);
                        this.tileTableNames.add(tableName);
                    }
                    catch (Throwable throwable2) {}
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        var2_2 = null;
        try {
            resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = 'tiles';");
            throwable = null;
            try {
                while (resultSet.next()) {
                    this.contentsTileTableNames.add(resultSet.getString(1));
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            var2_2 = throwable7;
            throw throwable7;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable8) {
                        var2_2.addSuppressed(throwable8);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    @BeforeTest
    public void validateTileLevelEnabled(ITestContext testContext) throws IOException {
        Map params = testContext.getSuite().getXmlSuite().getParameters();
        int level = Integer.parseInt((String)params.get(TestRunArg.ICS.toString()));
        if (level > 1) {
            Assert.assertTrue((boolean)true);
        } else {
            Assert.assertTrue((boolean)false, (String)"Tile level is not enabled");
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 34")
    public void tilesTablesAreReferenced() throws SQLException {
        Collection missingTileTableNames = this.tileTableNames.stream().filter(tableName -> !this.contentsTileTableNames.contains(tableName)).collect(Collectors.toList());
        Assert.assertTrue((boolean)missingTileTableNames.isEmpty(), (String)ErrorMessage.format("TilesTablesNotReferencedInContents", String.join((CharSequence)", ", missingTileTableNames)));
    }

    @Test(description="See OGC 12-128r12: Requirement 35")
    public void zoomTimesTwo() throws SQLException {
        for (String tableName : this.tileTableNames) {
            PreparedStatement preparedStatement = this.databaseConnection.prepareStatement("SELECT table_name, zoom_level, pixel_x_size, pixel_y_size, matrix_width, matrix_height, tile_width, tile_height FROM gpkg_tile_matrix WHERE table_name = ? ORDER BY zoom_level ASC;");
            Throwable throwable = null;
            try {
                preparedStatement.setString(1, tableName);
                ResultSet resultSet = preparedStatement.executeQuery();
                Throwable throwable2 = null;
                try {
                    int lastZoomLevel = Integer.MIN_VALUE;
                    double lastPixelXSize = 0.0;
                    double lastPixelYSize = 0.0;
                    while (resultSet.next()) {
                        int zoomLevel = resultSet.getInt("zoom_level");
                        double pixelXSize = resultSet.getDouble("pixel_x_size");
                        double pixelYSize = resultSet.getDouble("pixel_y_size");
                        if (zoomLevel == lastZoomLevel + 1) {
                            Assert.assertTrue((TileTests.isEqual(lastPixelXSize / 2.0, pixelXSize) && TileTests.isEqual(lastPixelYSize / 2.0, pixelYSize) ? 1 : 0) != 0, (String)ErrorMessage.format("ValuesDoNotVaryByFactorOfTwo", lastZoomLevel, zoomLevel));
                        }
                        lastZoomLevel = zoomLevel;
                        lastPixelXSize = pixelXSize;
                        lastPixelYSize = pixelYSize;
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (preparedStatement == null) continue;
                if (throwable != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                preparedStatement.close();
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 36")
    public void imageFormat() throws SQLException, IOException {
        for (String tableName : this.tileTableNames) {
            Statement statement = this.databaseConnection.createStatement();
            Throwable throwable = null;
            try {
                ResultSet resultSet = statement.executeQuery(String.format("SELECT tile_data, id FROM %s;", tableName));
                Throwable throwable2 = null;
                try {
                    LinkedList<Integer> failedTileIds = new LinkedList<Integer>();
                    while (resultSet.next()) {
                        byte[] tileData = resultSet.getBytes("tile_data");
                        if (TileTests.isAcceptedImageFormat(tileData)) continue;
                        failedTileIds.add(resultSet.getInt("id"));
                    }
                    Assert.assertTrue((boolean)failedTileIds.isEmpty(), (String)ErrorMessage.format("InvalidImageFormat", tableName, failedTileIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 37")
    public void imageFormatJpg() {
    }

    @Test(description="See OGC 12-128r12: Requirement 38")
    public void tileMatrixSetTable() throws SQLException {
        if (!this.tileTableNames.isEmpty()) {
            Assert.assertTrue((boolean)this.hasTileMatrixSetTable, (String)"TileMatrixSetTableDoesNotExist");
            try {
                HashMap<String, ColumnDefinition> tileMatrixSetColumns = new HashMap<String, ColumnDefinition>();
                tileMatrixSetColumns.put("table_name", new ColumnDefinition("TEXT", true, true, true, null));
                tileMatrixSetColumns.put("srs_id", new ColumnDefinition("INTEGER", true, false, false, null));
                tileMatrixSetColumns.put("min_x", new ColumnDefinition("DOUBLE", true, false, false, null));
                tileMatrixSetColumns.put("min_y", new ColumnDefinition("DOUBLE", true, false, false, null));
                tileMatrixSetColumns.put("max_x", new ColumnDefinition("DOUBLE", true, false, false, null));
                tileMatrixSetColumns.put("max_y", new ColumnDefinition("DOUBLE", true, false, false, null));
                TableVerifier.verifyTable(this.databaseConnection, "gpkg_tile_matrix_set", tileMatrixSetColumns, new HashSet<ForeignKeyDefinition>(Arrays.asList(new ForeignKeyDefinition("gpkg_spatial_ref_sys", "srs_id", "srs_id"), new ForeignKeyDefinition("gpkg_contents", "table_name", "table_name"))), Collections.emptyList());
            }
            catch (Throwable th) {
                AssertJUnit.fail((String)ErrorMessage.format("BadTileMatrixSetTableDefinition", th.getMessage()));
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 39")
    public void matrixSetNamesReferenceTiles() throws SQLException {
        if (this.hasTileMatrixSetTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_tile_matrix_set;");){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    Assert.assertTrue((boolean)this.contentsTileTableNames.contains(tableName), (String)ErrorMessage.format("UnreferencedTileMatrixSetTable", tableName));
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 40")
    public void matrixSetNameForEachTilesTable() throws SQLException {
        if (this.hasTileMatrixSetTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_tile_matrix_set;");){
                LinkedList<String> tableNames = new LinkedList<String>();
                while (resultSet.next()) {
                    tableNames.add(resultSet.getString("table_name"));
                }
                for (String tableName : this.contentsTileTableNames) {
                    Assert.assertTrue((boolean)tableNames.contains(tableName), (String)ErrorMessage.format("UnreferencedTilesContentTableName", tableName));
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 41")
    public void matrixSetSrsIdReferencesGoodId() throws SQLException {
        if (this.hasTileMatrixSetTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT srs_id from gpkg_tile_matrix_set WHERE srs_id NOT IN (SELECT srs_id FROM gpkg_spatial_ref_sys);");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)ErrorMessage.format("BadMatrixSetSrsReference", resultSet.getInt("srs_id")));
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 42")
    public void tileMatrixTableDefinition() throws SQLException {
        if (!this.tileTableNames.isEmpty()) {
            Assert.assertTrue((boolean)this.hasTileMatrixTable, (String)"TileMatrixTableDoesNotExist");
            try {
                HashMap<String, ColumnDefinition> tileMatrixColumns = new HashMap<String, ColumnDefinition>();
                tileMatrixColumns.put("table_name", new ColumnDefinition("TEXT", true, true, true, null));
                tileMatrixColumns.put("zoom_level", new ColumnDefinition("INTEGER", true, true, true, null));
                tileMatrixColumns.put("matrix_width", new ColumnDefinition("INTEGER", true, false, false, null));
                tileMatrixColumns.put("matrix_height", new ColumnDefinition("INTEGER", true, false, false, null));
                tileMatrixColumns.put("tile_width", new ColumnDefinition("INTEGER", true, false, false, null));
                tileMatrixColumns.put("tile_height", new ColumnDefinition("INTEGER", true, false, false, null));
                tileMatrixColumns.put("pixel_x_size", new ColumnDefinition("DOUBLE", true, false, false, null));
                tileMatrixColumns.put("pixel_y_size", new ColumnDefinition("DOUBLE", true, false, false, null));
                TableVerifier.verifyTable(this.databaseConnection, "gpkg_tile_matrix", tileMatrixColumns, new HashSet<ForeignKeyDefinition>(Arrays.asList(new ForeignKeyDefinition("gpkg_contents", "table_name", "table_name"))), Collections.emptyList());
            }
            catch (Throwable th) {
                AssertJUnit.fail((String)ErrorMessage.format("BadTileMatrixTableDefinition", th.getMessage()));
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 43")
    public void tileMatrixTableContentsReferences() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_tile_matrix AS tm WHERE table_name NOT IN (SELECT table_name FROM gpkg_contents AS gc WHERE tm.table_name = gc.table_name AND gc.data_type = 'tiles');");){
                LinkedList<String> unreferencedTables = new LinkedList<String>();
                while (resultSet.next()) {
                    unreferencedTables.add(resultSet.getString("table_name"));
                }
                Assert.assertTrue((boolean)unreferencedTables.isEmpty(), (String)ErrorMessage.format("BadMatrixContentsReferences", String.join((CharSequence)", ", unreferencedTables)));
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 44")
    public void tileMatrixPerZoomLevel() throws SQLException {
        if (this.hasTileMatrixTable) {
            for (String tableName : this.tileTableNames) {
                Object gmZoomLevels2;
                LinkedList<Integer> tileMatrixZooms = new LinkedList<Integer>();
                PreparedStatement statement = this.databaseConnection.prepareStatement("SELECT DISTINCT zoom_level FROM gpkg_tile_matrix WHERE table_name = ? ORDER BY zoom_level;");
                Object object = null;
                try {
                    statement.setString(1, tableName);
                    gmZoomLevels2 = statement.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (gmZoomLevels2.next()) {
                            tileMatrixZooms.add(gmZoomLevels2.getInt("zoom_level"));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (gmZoomLevels2 != null) {
                            if (throwable != null) {
                                try {
                                    gmZoomLevels2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                gmZoomLevels2.close();
                            }
                        }
                    }
                }
                catch (Throwable gmZoomLevels2) {
                    object = gmZoomLevels2;
                    throw gmZoomLevels2;
                }
                finally {
                    if (statement != null) {
                        if (object != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable gmZoomLevels2) {
                                ((Throwable)object).addSuppressed(gmZoomLevels2);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
                LinkedList<Integer> tilePyramidZooms = new LinkedList<Integer>();
                Statement statement2 = this.databaseConnection.createStatement();
                gmZoomLevels2 = null;
                try (ResultSet pyZoomLevels = statement2.executeQuery(String.format("SELECT DISTINCT zoom_level FROM %s ORDER BY zoom_level;", tableName));){
                    while (pyZoomLevels.next()) {
                        tilePyramidZooms.add(pyZoomLevels.getInt("zoom_level"));
                    }
                }
                catch (Throwable throwable) {
                    gmZoomLevels2 = throwable;
                    throw throwable;
                }
                finally {
                    if (statement2 != null) {
                        if (gmZoomLevels2 != null) {
                            try {
                                statement2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)gmZoomLevels2).addSuppressed(throwable);
                            }
                        } else {
                            statement2.close();
                        }
                    }
                }
                for (Integer zoom : tilePyramidZooms) {
                    Assert.assertTrue((boolean)tileMatrixZooms.contains(zoom), (String)ErrorMessage.format("MissingTileMatrixEntry", zoom, tableName));
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 45")
    public void tileMatrixDimensionAgreement() throws SQLException {
        if (this.hasTileMatrixTable && this.hasTileMatrixSetTable) {
            HashMap tableNamesWithBadZooms = new HashMap();
            for (String tableName : this.tileTableNames) {
                PreparedStatement preparedStatement = this.databaseConnection.prepareStatement("SELECT min_x, min_y, max_x, max_y FROM gpkg_tile_matrix_set WHERE table_name = ?");
                Throwable throwable = null;
                try {
                    preparedStatement.setString(1, tableName);
                    ResultSet boundingBox = preparedStatement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        if (!boundingBox.next()) continue;
                        double width = boundingBox.getDouble("max_x") - boundingBox.getDouble("min_x");
                        double height = boundingBox.getDouble("max_y") - boundingBox.getDouble("min_y");
                        ArrayList<Integer> zoomLevels = new ArrayList<Integer>();
                        try (PreparedStatement statement = this.databaseConnection.prepareStatement("SELECT zoom_level, pixel_x_size, pixel_y_size, matrix_width, matrix_height, tile_width, tile_height FROM gpkg_tile_matrix WHERE table_name = ? ORDER BY zoom_level ASC;");){
                            statement.setString(1, tableName);
                            try (ResultSet pixelInfo = statement.executeQuery();){
                                while (pixelInfo.next()) {
                                    double pixelXSize = pixelInfo.getDouble("pixel_x_size");
                                    double pixelYSize = pixelInfo.getDouble("pixel_y_size");
                                    double matrixHeight = pixelInfo.getInt("matrix_height");
                                    double matrixWidth = pixelInfo.getInt("matrix_width");
                                    double tileHeight = pixelInfo.getInt("tile_height");
                                    double tileWidth = pixelInfo.getInt("tile_width");
                                    if (TileTests.isEqual(pixelXSize, width / matrixWidth / tileWidth) && TileTests.isEqual(pixelYSize, height / matrixHeight / tileHeight)) continue;
                                    zoomLevels.add(pixelInfo.getInt("zoom_level"));
                                }
                            }
                        }
                        if (zoomLevels.isEmpty()) continue;
                        tableNamesWithBadZooms.put(tableName, zoomLevels);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (boundingBox == null) continue;
                        if (throwable2 != null) {
                            try {
                                boundingBox.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        boundingBox.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
            Assert.assertTrue((boolean)tableNamesWithBadZooms.isEmpty(), (String)ErrorMessage.format("BadPixelDimensions", tableNamesWithBadZooms.entrySet().stream().map(entrySet -> String.format("%s: %s", entrySet.getKey(), ((Collection)entrySet.getValue()).stream().map(Object::toString).collect(Collectors.joining(", ")))).collect(Collectors.joining("\n"))));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 46")
    public void zoomLevelNotNegative() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT zoom_level FROM gpkg_tile_matrix WHERE zoom_level < 0;");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)"NegativeZoomLevel");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 47")
    public void matrixWidthGreaterThanZero() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT matrix_width FROM gpkg_tile_matrix WHERE matrix_width <= 0;");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)"NonPositiveMatrixWidth");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 48")
    public void matrixHeightGreaterThanZero() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT matrix_height FROM gpkg_tile_matrix WHERE matrix_height <= 0;");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)"NonPositiveMatrixHeight");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 49")
    public void tileWidthGreaterThanZero() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT tile_width FROM gpkg_tile_matrix WHERE tile_width <= 0;");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)"NonPositiveTileWidth");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 50")
    public void tileHeightGreaterThanZero() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT tile_height FROM gpkg_tile_matrix WHERE tile_height <= 0;");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)"NonPositiveTileHeight");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 51")
    public void pixelXSizeGreaterThanZero() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT pixel_x_size FROM gpkg_tile_matrix WHERE pixel_x_size <= 0;");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)"NonPositivePixelXSize");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 52")
    public void pixelYSizeGreaterThanZero() throws SQLException {
        if (this.hasTileMatrixTable) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT pixel_y_size FROM gpkg_tile_matrix WHERE pixel_y_size <= 0;");){
                if (resultSet.next()) {
                    AssertJUnit.fail((String)"NonPositivePixelYSize");
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 53")
    public void sortedPixelSizes() throws SQLException {
        if (this.hasTileMatrixTable) {
            for (String pyramidTable : this.tileTableNames) {
                PreparedStatement statement = this.databaseConnection.prepareStatement("SELECT pixel_x_size, pixel_y_size FROM gpkg_tile_matrix WHERE table_name = ? ORDER BY zoom_level ASC;");
                Throwable throwable = null;
                try {
                    statement.setString(1, pyramidTable);
                    ResultSet resultSet = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        if (!resultSet.isBeforeFirst()) continue;
                        resultSet.next();
                        double lastPixelX = resultSet.getDouble("pixel_x_size");
                        double lastPixelY = resultSet.getDouble("pixel_y_size");
                        while (resultSet.next()) {
                            double pixelX = resultSet.getDouble("pixel_x_size");
                            double pixelY = resultSet.getDouble("pixel_y_size");
                            Assert.assertTrue((lastPixelX > pixelX && lastPixelY > pixelY ? 1 : 0) != 0, (String)ErrorMessage.format("PixelSizeNotDecreasing", pyramidTable));
                            lastPixelX = pixelX;
                            lastPixelY = pixelY;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 54")
    public void tilesTableDefinitions() throws SQLException {
        HashMap<String, ColumnDefinition> expectedColumns = new HashMap<String, ColumnDefinition>();
        expectedColumns.put("id", new ColumnDefinition("INTEGER", true, true, true, null));
        expectedColumns.put("zoom_level", new ColumnDefinition("INTEGER", true, false, false, null));
        expectedColumns.put("tile_column", new ColumnDefinition("INTEGER", true, false, false, null));
        expectedColumns.put("tile_row", new ColumnDefinition("INTEGER", true, false, false, null));
        expectedColumns.put("tile_data", new ColumnDefinition("BLOB", true, false, false, null));
        for (String tableName : this.contentsTileTableNames) {
            try {
                TableVerifier.verifyTable(this.databaseConnection, tableName, expectedColumns, Collections.emptySet(), new HashSet<UniqueDefinition>(Arrays.asList(new UniqueDefinition("zoom_level", "tile_column", "tile_row"))));
            }
            catch (Throwable th) {
                AssertJUnit.fail((String)ErrorMessage.format("BadTilePyramidUserDataTableDefinition", tableName, th.getMessage()));
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 55")
    public void zoomLevelRange() throws SQLException {
        if (this.hasTileMatrixTable) {
            for (String tableName : this.tileTableNames) {
                PreparedStatement statement = this.databaseConnection.prepareStatement("SELECT MIN(zoom_level) AS min_zoom, MAX(zoom_level) AS max_zoom FROM gpkg_tile_matrix WHERE table_name = ?;");
                Throwable throwable = null;
                try {
                    statement.setString(1, tableName);
                    ResultSet minMaxZoom = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        int minZoom = minMaxZoom.getInt("min_zoom");
                        int maxZoom = minMaxZoom.getInt("max_zoom");
                        if (minMaxZoom.wasNull()) continue;
                        PreparedStatement zoomStatement = this.databaseConnection.prepareStatement(String.format("SELECT zoom_level FROM %s WHERE zoom_level < ? OR zoom_level > ?", tableName));
                        Throwable throwable3 = null;
                        try {
                            zoomStatement.setInt(1, minZoom);
                            zoomStatement.setInt(2, maxZoom);
                            ResultSet invalidZooms = zoomStatement.executeQuery();
                            Throwable throwable4 = null;
                            try {
                                if (!invalidZooms.next()) continue;
                                AssertJUnit.fail((String)ErrorMessage.format("UndefinedZoomLevel", tableName, invalidZooms.getInt("zoom_level")));
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (invalidZooms == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        invalidZooms.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                invalidZooms.close();
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable3 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (zoomStatement == null) continue;
                            if (throwable3 != null) {
                                try {
                                    zoomStatement.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            zoomStatement.close();
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable2 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (minMaxZoom == null) continue;
                        if (throwable2 != null) {
                            try {
                                minMaxZoom.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        minMaxZoom.close();
                    }
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 56")
    public void tileColumnRange() throws SQLException {
        if (this.hasTileMatrixTable) {
            for (String tableName : this.tileTableNames) {
                String query = String.format("SELECT zoom_level as zl, matrix_width as width FROM   gpkg_tile_matrix WHERE  table_name = ? AND (zoom_level in (SELECT zoom_level FROM %1$s WHERE tile_column < 0) OR  (EXISTS(SELECT NULL FROM %1$s WHERE zoom_level = zl AND tile_column > width - 1)));", tableName);
                PreparedStatement statement = this.databaseConnection.prepareStatement(query);
                Throwable throwable = null;
                try {
                    statement.setString(1, tableName);
                    ResultSet resultSet = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (resultSet.next()) {
                            int matrixWidth = resultSet.getInt("width");
                            int zoomLevel = resultSet.getInt("zl");
                            AssertJUnit.fail((String)ErrorMessage.format("TileColumnOutOfRange", tableName, matrixWidth - 1, zoomLevel));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 57")
    public void tileRowRange() throws SQLException {
        if (this.hasTileMatrixTable) {
            for (String tableName : this.tileTableNames) {
                String query = String.format("SELECT zoom_level as zl, matrix_height as height FROM   gpkg_tile_matrix WHERE  table_name = ? AND (zoom_level in (SELECT zoom_level FROM %1$s WHERE tile_row < 0) OR  (EXISTS(SELECT NULL FROM %1$s WHERE zoom_level = zl AND tile_row > height - 1)));", tableName);
                PreparedStatement statement = this.databaseConnection.prepareStatement(query);
                Throwable throwable = null;
                try {
                    statement.setString(1, tableName);
                    ResultSet resultSet = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (resultSet.next()) {
                            int matrixHeight = resultSet.getInt("height");
                            int zoomLevel = resultSet.getInt("zl");
                            AssertJUnit.fail((String)ErrorMessage.format("TileRowOutOfRange", tableName, matrixHeight - 1, zoomLevel));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
    }

    private static boolean isEqual(double first, double second) {
        return Math.abs(first - second) < 1.0E-4;
    }

    /*
     * Exception decompiling
     */
    private static boolean isAcceptedImageFormat(byte[] image) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canReadImage(Iterable<ImageReader> imageReaders, ImageInputStream image) throws IOException {
        for (ImageReader imageReader : imageReaders) {
            try {
                image.mark();
                if (!imageReader.getOriginatingProvider().canDecodeInput(image)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                image.reset();
            }
        }
        return false;
    }

    static {
        TileTableExpectedColumns.put("id", new ColumnDefinition("INTEGER", false, true, true, null));
        TileTableExpectedColumns.put("zoom_level", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_column", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_row", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_data", new ColumnDefinition("BLOB", true, false, false, null));
        TileTableExpectedForeignKeys = Collections.emptySet();
        TileTableExpectedUniqueColumnGroups = new HashSet<UniqueDefinition>(Arrays.asList(new UniqueDefinition("zoom_level", "tile_column", "tile_row")));
    }
}

