/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Suite {
    private String prefix;
    private String namespaceUri;
    private String localName;
    private String title;
    private String description;
    private String startingTestPrefix;
    private String startingTestNamespaceUri;
    private String startingTestLocalName;
    private String link;
    private String dataLink;
    private String version;

    public Suite(Element suiteElement) {
        String name = suiteElement.getAttribute("name");
        this.version = suiteElement.getAttribute("version");
        int colon = name.indexOf(":");
        this.prefix = name.substring(0, colon);
        this.localName = name.substring(colon + 1);
        this.namespaceUri = suiteElement.lookupNamespaceURI(this.prefix);
        NodeList titleElements = suiteElement.getElementsByTagNameNS("http://www.occamlab.com/ctl", "title");
        this.title = ((Element)titleElements.item(0)).getTextContent();
        NodeList descElements = suiteElement.getElementsByTagNameNS("http://www.occamlab.com/ctl", "description");
        this.description = descElements.getLength() > 0 ? ((Element)descElements.item(0)).getTextContent() : null;
        NodeList linkElements = suiteElement.getElementsByTagNameNS("http://www.occamlab.com/ctl", "link");
        for (int i = 0; i < linkElements.getLength(); ++i) {
            Element linkElem = (Element)linkElements.item(i);
            String linkText = linkElem.getTextContent();
            if (linkText.startsWith("data")) {
                this.dataLink = linkText;
                continue;
            }
            this.link = linkText;
        }
        NodeList startingTestElements = suiteElement.getElementsByTagNameNS("http://www.occamlab.com/ctl", "starting-test");
        name = ((Element)startingTestElements.item(0)).getTextContent();
        colon = name.indexOf(":");
        this.startingTestPrefix = name.substring(0, colon);
        this.startingTestLocalName = name.substring(colon + 1);
        this.startingTestNamespaceUri = suiteElement.lookupNamespaceURI(this.startingTestPrefix);
    }

    public String getKey() {
        return this.namespaceUri + "," + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLink() {
        return this.link;
    }

    public String getDataLink() {
        return this.dataLink;
    }

    public String getStartingTestPrefix() {
        return this.startingTestPrefix;
    }

    public String getStartingTestNamespaceUri() {
        return this.startingTestNamespaceUri;
    }

    public String getStartingTestLocalName() {
        return this.startingTestLocalName;
    }

    public String getVersion() {
        return this.version;
    }
}

