/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources;

import com.occamlab.te.spi.stats.SessionDetails;
import com.occamlab.te.spi.util.TEStatisticsUtil;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Path(value="stats")
public class TEStatistics {
    static Logger logger = Logger.getLogger(TEStatistics.class.getName());

    @GET
    @Produces(value={"application/zip;qs=0.25;charset=utf-8"})
    public Response generateStatisticsReport() throws IOException {
        Source results = this.generateStatisticsReports();
        String htmlOutput = results.getSystemId().toString();
        Integer count = htmlOutput.split(":", -1).length - 1;
        String zipFile = count > 1 ? htmlOutput.split("file:/")[1] : htmlOutput.split("file:")[1];
        String fileName = zipFile.substring(zipFile.lastIndexOf("/") + 1);
        File fileOut = new File(zipFile);
        if (!fileOut.exists()) {
            throw new WebApplicationException(404);
        }
        return Response.ok(FileUtils.readFileToByteArray(fileOut)).type("application/zip").header("Content-Disposition", "attachment; filename=" + fileName).header("Cache-Control", "no-cache").build();
    }

    private Source generateStatisticsReports() {
        String teBasePath = System.getProperty("TE_BASE");
        if (null == teBasePath || teBasePath.isEmpty() || !new File(teBasePath).exists()) {
            throw new WebApplicationException(Response.serverError().entity("TE_BASE directory does not exists.").type("text/plain").build());
        }
        File configFile = new File(teBasePath + "/config.xml");
        if (!configFile.exists()) {
            throw new WebApplicationException(Response.serverError().entity("Config file does not exists in TE_BASE directory.").type("text/plain").build());
        }
        File usersDir = new File(teBasePath + "/users");
        if (!usersDir.exists()) {
            throw new WebApplicationException(Response.serverError().entity("User directory does not exists in TE_BASE directory.").type("text/plain").build());
        }
        DateTime logDate = new DateTime();
        DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy-MM-dd_HH-mm-ss");
        String loggerDate = formatter.print(logDate);
        Integer year = logDate.getYear();
        File statisticsLogDir = new File(System.getProperty("java.io.tmpdir"));
        File statisticsLogFile = new File(System.getProperty("java.io.tmpdir"), "TE_StatisticsLog.log");
        File statisticsResultDir = new File(System.getProperty("java.io.tmpdir"), "TE_Statistics_" + loggerDate);
        if (!statisticsLogDir.exists()) {
            statisticsLogDir.mkdir();
        }
        if (statisticsLogFile.exists()) {
            statisticsLogFile.delete();
        }
        FileHandler logFile = null;
        try {
            logFile = new FileHandler(statisticsLogFile.toString(), true);
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
        }
        logger.setUseParentHandlers(false);
        logFile.setFormatter(new SimpleFormatter());
        logger.addHandler(logFile);
        Map<String, List<SessionDetails>> userDetails = TEStatisticsUtil.processUserDir(usersDir);
        Document doc = TEStatisticsUtil.parse(configFile);
        NodeList standardList = doc.getElementsByTagName("standard");
        ArrayList<String> testSuitesName = new ArrayList<String>();
        HashMap<String, Object> allTestSuiteRunDetails = new HashMap<String, Object>();
        Integer i = 0;
        while (i < standardList.getLength()) {
            Object testName = "";
            Element standard = (Element)standardList.item(i);
            NodeList nameList = standard.getElementsByTagName("name");
            NodeList versionList = standard.getElementsByTagName("version");
            testName = nameList.item(0).getTextContent();
            Integer j = 0;
            while (j < versionList.getLength()) {
                Object version = (Element)versionList.item(j);
                NodeList versionValue = version.getElementsByTagName("name");
                Object testSuiteName = "";
                if (!"".equals(testName)) {
                    testSuiteName = (String)testName + "_";
                }
                testSuiteName = (String)testSuiteName + versionValue.item(0).getTextContent();
                testSuitesName.add((String)testSuiteName);
                ArrayList<Long> numberOfUsersExecutedTestSuitePerMonth = TEStatisticsUtil.numberOfUsersExecutedTestSuitePerMonth((String)testSuiteName, userDetails);
                ArrayList<Long> testSuiteRunPerMonth = TEStatisticsUtil.testSuiteRunPerMonth((String)testSuiteName, userDetails);
                HashMap<String, Integer> testStatus = new HashMap<String, Integer>();
                testStatus.put("Success", 1);
                testStatus.put("Failure", 6);
                testStatus.put("Incomplete", 0);
                Map<String, ArrayList<Long>> testSuiteStatusPerMonth = TEStatisticsUtil.testSuiteStatusPerMonth((String)testSuiteName, userDetails, testStatus);
                ArrayList<Long> successArray = testSuiteStatusPerMonth.get("Success");
                ArrayList<Long> failureArray = testSuiteStatusPerMonth.get("Failure");
                ArrayList<Long> incompleteArray = testSuiteStatusPerMonth.get("Incomplete");
                Map<String, Object> testSuiteStatusWithDrilldown = TEStatisticsUtil.testSuiteStatusWithDrilldown((String)testSuiteName, userDetails, testStatus);
                Map<String, Long> testSuiteFailedTestDrillDownMap = TEStatisticsUtil.testSuiteFailedTestDrillDownMap;
                TEStatisticsUtil.generateTestSuiteStatisticsHtmlReport((String)testSuiteName, year, statisticsResultDir, TEStatisticsUtil.getArrayListAsString(numberOfUsersExecutedTestSuitePerMonth), TEStatisticsUtil.getArrayListAsString(testSuiteRunPerMonth), TEStatisticsUtil.getArrayListAsString(successArray), TEStatisticsUtil.getArrayListAsString(failureArray), TEStatisticsUtil.getArrayListAsString(incompleteArray), new JSONObject(testSuiteStatusWithDrilldown).toString(), new JSONObject(testSuiteFailedTestDrillDownMap).toString());
                Map<String, Object> testSuiteRunDetails = TEStatisticsUtil.testSuiteRunDetailsOfCurrentYear((String)testSuiteName, userDetails);
                allTestSuiteRunDetails.putAll(testSuiteRunDetails);
                version = j;
                j = j + 1;
            }
            testName = i;
            i = i + 1;
        }
        ArrayList<Long> testsRunPerMonth = TEStatisticsUtil.testsRunPerMonthofCurrentYear(userDetails);
        ArrayList<Long> usersPerMonth = TEStatisticsUtil.usersPerMonthofCurrentYear(userDetails);
        Map<Object, Object> numberOfUsersPerTestSuite = new HashMap();
        HashMap numberOfUsersAndTestSuite = new HashMap();
        for (String testSuiteName : testSuitesName) {
            numberOfUsersPerTestSuite = TEStatisticsUtil.numberOfUsersPerTestSuite(testSuiteName, userDetails);
            numberOfUsersAndTestSuite.putAll(numberOfUsersPerTestSuite);
        }
        TEStatisticsUtil.generateOverallStatisticsHtmlReport(testSuitesName, year, statisticsResultDir, new JSONObject(allTestSuiteRunDetails).toString(), TEStatisticsUtil.getArrayListAsString(testsRunPerMonth), TEStatisticsUtil.getArrayListAsString(usersPerMonth), new JSONObject((Map)numberOfUsersAndTestSuite).toString());
        File zipFile = new File(statisticsLogDir, "TE_Statistics_" + loggerDate + ".zip");
        if (zipFile.exists()) {
            zipFile.delete();
        }
        SAXSource results = null;
        try {
            TEStatisticsUtil.zipDir(zipFile, statisticsResultDir);
            FileInputStream inStream = new FileInputStream(zipFile);
            InputSource inSource = new InputSource(new InputStreamReader((InputStream)inStream, StandardCharsets.UTF_8));
            results = new SAXSource(inSource);
            results.setSystemId(zipFile.toURI().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }
}

