/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public abstract class NodeTest
implements ItemType,
Serializable {
    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (item instanceof NodeInfo) {
            return this.matches((NodeInfo)item);
        }
        return false;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        return AnyNodeTest.getInstance();
    }

    public abstract double getDefaultPriority();

    public ItemType getPrimitiveItemType() {
        int p = this.getPrimitiveType();
        if (p == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(p);
    }

    public int getPrimitiveType() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public boolean isAtomicType() {
        return false;
    }

    public AtomicType getAtomizedItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        return this.matches(tree.getNode(nodeNr));
    }

    public abstract boolean matches(int var1, int var2, int var3);

    public boolean matches(NodeInfo node) {
        return this.matches(node.getNodeKind(), node.getFingerprint(), node.getTypeAnnotation());
    }

    public int getNodeKindMask() {
        return 9102;
    }

    public SchemaType getContentType() {
        return AnyType.getInstance();
    }

    public IntHashSet getRequiredNodeNames() {
        return null;
    }

    public boolean isNillable() {
        return false;
    }

    public String toString(NamePool pool) {
        return this.toString();
    }
}

