/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

public class LineNumberMap {
    private int[] sequenceNumbers = new int[1000];
    private int[] lineNumbers = new int[1000];
    private int allocated = 0;

    public void setLineNumber(int sequence, int line) {
        if (this.sequenceNumbers.length <= this.allocated + 1) {
            int[] s2 = new int[this.allocated * 2];
            int[] l = new int[this.allocated * 2];
            System.arraycopy(this.sequenceNumbers, 0, s2, 0, this.allocated);
            System.arraycopy(this.lineNumbers, 0, l, 0, this.allocated);
            this.sequenceNumbers = s2;
            this.lineNumbers = l;
        }
        this.sequenceNumbers[this.allocated] = sequence;
        this.lineNumbers[this.allocated] = line;
        ++this.allocated;
    }

    public int getLineNumber(int sequence) {
        for (int i = 1; i < this.allocated; ++i) {
            if (this.sequenceNumbers[i] <= sequence) continue;
            return this.lineNumbers[i - 1];
        }
        return this.lineNumbers[this.allocated - 1];
    }
}

