/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.ComponentPatternParser;
import org.apache.jena.iri.impl.GroupAction;
import org.apache.jena.iri.impl.Parser;

public class ComponentPattern
implements ViolationCodes {
    final Pattern pattern;
    final GroupAction[] actions;
    static final List<Pattern> allPatterns = new ArrayList<Pattern>();

    ComponentPattern(String p) {
        ComponentPatternParser parser = new ComponentPatternParser(p);
        this.pattern = parser.get();
        this.actions = parser.actions();
        allPatterns.add(this.pattern);
    }

    public void analyse(Parser parser, int range) {
        Matcher m4 = this.pattern.matcher(parser.get(range));
        if (!m4.matches()) {
            parser.recordError(range, 61);
            return;
        }
        for (int g2 = 1; g2 <= m4.groupCount(); ++g2) {
            if (m4.start(g2) == -1) continue;
            this.actions[g2].check(m4, parser, range);
        }
    }
}

