/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.impl.AbstractProfile;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class RDFSProfile
extends AbstractProfile {
    private static Object[][] s_supportsCheckTable = new Object[][]{{OntClass.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), RDFS.Class.asNode()) || g2.asGraph().contains(n, RDF.type.asNode(), RDFS.Datatype.asNode()) || n.equals(RDFS.Resource.asNode()) || g2.asGraph().contains(Node.ANY, RDFS.domain.asNode(), n) || g2.asGraph().contains(Node.ANY, RDFS.range.asNode(), n);
        }
    }}, {RDFList.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return n.equals(RDF.nil.asNode()) || g2.asGraph().contains(n, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), RDF.Property.asNode());
        }
    }}};
    protected static HashMap<Object, Object> s_supportsChecks = new HashMap();

    @Override
    public String NAMESPACE() {
        return RDFS.getURI();
    }

    @Override
    public Resource CLASS() {
        return RDFS.Class;
    }

    @Override
    public Resource RESTRICTION() {
        return null;
    }

    @Override
    public Resource THING() {
        return null;
    }

    @Override
    public Resource NOTHING() {
        return null;
    }

    @Override
    public Resource PROPERTY() {
        return RDF.Property;
    }

    @Override
    public Resource OBJECT_PROPERTY() {
        return null;
    }

    @Override
    public Resource DATATYPE_PROPERTY() {
        return null;
    }

    @Override
    public Resource TRANSITIVE_PROPERTY() {
        return null;
    }

    @Override
    public Resource SYMMETRIC_PROPERTY() {
        return null;
    }

    @Override
    public Resource FUNCTIONAL_PROPERTY() {
        return null;
    }

    @Override
    public Resource INVERSE_FUNCTIONAL_PROPERTY() {
        return null;
    }

    @Override
    public Resource ALL_DIFFERENT() {
        return null;
    }

    @Override
    public Resource ONTOLOGY() {
        return null;
    }

    @Override
    public Resource DEPRECATED_CLASS() {
        return null;
    }

    @Override
    public Resource DEPRECATED_PROPERTY() {
        return null;
    }

    @Override
    public Resource ANNOTATION_PROPERTY() {
        return null;
    }

    @Override
    public Resource ONTOLOGY_PROPERTY() {
        return null;
    }

    @Override
    public Resource LIST() {
        return RDF.List;
    }

    @Override
    public Resource NIL() {
        return RDF.nil;
    }

    @Override
    public Resource DATARANGE() {
        return null;
    }

    @Override
    public Property EQUIVALENT_PROPERTY() {
        return null;
    }

    @Override
    public Property EQUIVALENT_CLASS() {
        return null;
    }

    @Override
    public Property DISJOINT_WITH() {
        return null;
    }

    @Override
    public Property SAME_INDIVIDUAL_AS() {
        return null;
    }

    @Override
    public Property SAME_AS() {
        return null;
    }

    @Override
    public Property DIFFERENT_FROM() {
        return null;
    }

    @Override
    public Property DISTINCT_MEMBERS() {
        return null;
    }

    @Override
    public Property UNION_OF() {
        return null;
    }

    @Override
    public Property INTERSECTION_OF() {
        return null;
    }

    @Override
    public Property COMPLEMENT_OF() {
        return null;
    }

    @Override
    public Property ONE_OF() {
        return null;
    }

    @Override
    public Property ON_PROPERTY() {
        return null;
    }

    @Override
    public Property ALL_VALUES_FROM() {
        return null;
    }

    @Override
    public Property HAS_VALUE() {
        return null;
    }

    @Override
    public Property SOME_VALUES_FROM() {
        return null;
    }

    @Override
    public Property MIN_CARDINALITY() {
        return null;
    }

    @Override
    public Property MAX_CARDINALITY() {
        return null;
    }

    @Override
    public Property CARDINALITY() {
        return null;
    }

    @Override
    public Property INVERSE_OF() {
        return null;
    }

    @Override
    public Property IMPORTS() {
        return null;
    }

    @Override
    public Property PRIOR_VERSION() {
        return null;
    }

    @Override
    public Property BACKWARD_COMPATIBLE_WITH() {
        return null;
    }

    @Override
    public Property INCOMPATIBLE_WITH() {
        return null;
    }

    @Override
    public Property SUB_PROPERTY_OF() {
        return RDFS.subPropertyOf;
    }

    @Override
    public Property SUB_CLASS_OF() {
        return RDFS.subClassOf;
    }

    @Override
    public Property DOMAIN() {
        return RDFS.domain;
    }

    @Override
    public Property RANGE() {
        return RDFS.range;
    }

    @Override
    public Property FIRST() {
        return RDF.first;
    }

    @Override
    public Property REST() {
        return RDF.rest;
    }

    @Override
    public Property MIN_CARDINALITY_Q() {
        return null;
    }

    @Override
    public Property MAX_CARDINALITY_Q() {
        return null;
    }

    @Override
    public Property CARDINALITY_Q() {
        return null;
    }

    @Override
    public Property HAS_CLASS_Q() {
        return null;
    }

    @Override
    public Property VERSION_INFO() {
        return null;
    }

    @Override
    public Property LABEL() {
        return RDFS.label;
    }

    @Override
    public Property COMMENT() {
        return RDFS.comment;
    }

    @Override
    public Property SEE_ALSO() {
        return RDFS.seeAlso;
    }

    @Override
    public Property IS_DEFINED_BY() {
        return RDFS.isDefinedBy;
    }

    @Override
    protected Resource[][] aliasTable() {
        return new Resource[][]{new Resource[0]};
    }

    @Override
    public Iterator<Resource> getAxiomTypes() {
        return Arrays.asList(new Resource[0]).iterator();
    }

    @Override
    public Iterator<Resource> getAnnotationProperties() {
        return Arrays.asList(RDFS.label, RDFS.seeAlso, RDFS.comment, RDFS.isDefinedBy).iterator();
    }

    @Override
    public Iterator<Resource> getClassDescriptionTypes() {
        return Arrays.asList(RDFS.Class).iterator();
    }

    @Override
    public <T> boolean isSupported(Node n, EnhGraph g2, Class<T> type) {
        if (g2 instanceof OntModel) {
            OntModel m4 = (OntModel)((Object)g2);
            if (!m4.strictMode()) {
                return true;
            }
            SupportsCheck check = (SupportsCheck)s_supportsChecks.get(type);
            return check == null || check.doCheck(n, g2);
        }
        return false;
    }

    @Override
    public String getLabel() {
        return "RDFS";
    }

    static {
        for (Object[] aS_supportsCheckTable : s_supportsCheckTable) {
            s_supportsChecks.put(aS_supportsCheckTable[0], aS_supportsCheckTable[1]);
        }
    }

    protected static class SupportsCheck {
        protected SupportsCheck() {
        }

        public boolean doCheck(Node n, EnhGraph g2) {
            return true;
        }
    }
}

