/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.apache.connector;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.ChunkedOutputStream;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.TextUtils;
import org.apache.http.util.VersionInfo;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.glassfish.jersey.apache.connector.ApacheHttpClientBuilderConfigurator;
import org.glassfish.jersey.apache.connector.LocalizationMessages;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.innate.ClientProxy;
import org.glassfish.jersey.client.innate.http.SSLParamConfigurator;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.innate.io.InputStreamWrapper;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.message.internal.Statuses;

class ApacheConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(ApacheConnector.class.getName());
    private static final String JERSEY_REQUEST_ATTR_NAME = "JerseyRequestAttribute";
    private static final VersionInfo vi = VersionInfo.loadVersionInfo("org.apache.http.client", HttpClientBuilder.class.getClassLoader());
    private static final String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
    private final CloseableHttpClient client;
    private final CookieStore cookieStore;
    private final boolean preemptiveBasicAuth;
    private final RequestConfig requestConfig;

    ApacheConnector(Client client, Configuration config) {
        Object retryHandler;
        Object reqConfig;
        Object reuseStrategy;
        Object keepAliveStrategy;
        Object connectionManager = config.getProperties().get("jersey.config.apache.client.connectionManager");
        if (connectionManager != null && !(connectionManager instanceof HttpClientConnectionManager)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.connectionManager", connectionManager.getClass().getName(), HttpClientConnectionManager.class.getName()));
        }
        if ((keepAliveStrategy = config.getProperties().get("jersey.config.apache.client.keepAliveStrategy")) != null && !(keepAliveStrategy instanceof ConnectionKeepAliveStrategy)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.keepAliveStrategy", keepAliveStrategy.getClass().getName(), ConnectionKeepAliveStrategy.class.getName()));
            keepAliveStrategy = null;
        }
        if ((reuseStrategy = config.getProperties().get("jersey.config.apache.client.reuseStrategy")) != null && !(reuseStrategy instanceof ConnectionReuseStrategy)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.reuseStrategy", reuseStrategy.getClass().getName(), ConnectionReuseStrategy.class.getName()));
            reuseStrategy = null;
        }
        if ((reqConfig = config.getProperties().get("jersey.config.apache.client.requestConfig")) != null && !(reqConfig instanceof RequestConfig)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.requestConfig", reqConfig.getClass().getName(), RequestConfig.class.getName()));
            reqConfig = null;
        }
        boolean useSystemProperties = PropertiesHelper.isProperty(config.getProperties(), "jersey.config.apache.client.useSystemProperties");
        SSLContext sslContext = client.getSslContext();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (useSystemProperties) {
            clientBuilder.useSystemProperties();
        }
        clientBuilder.setConnectionManager(this.getConnectionManager(client, config, sslContext, useSystemProperties));
        clientBuilder.setConnectionManagerShared(PropertiesHelper.getValue(config.getProperties(), "jersey.config.apache.client.connectionManagerShared", false, null));
        clientBuilder.setSSLContext(sslContext);
        if (keepAliveStrategy != null) {
            clientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)keepAliveStrategy);
        }
        if (reuseStrategy != null) {
            clientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)reuseStrategy);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        Object credentialsProvider = config.getProperty("jersey.config.apache.client.credentialsProvider");
        if (credentialsProvider != null && credentialsProvider instanceof CredentialsProvider) {
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if ((retryHandler = config.getProperties().get("jersey.config.apache.client.retryHandler")) != null && retryHandler instanceof HttpRequestRetryHandler) {
            clientBuilder.setRetryHandler((HttpRequestRetryHandler)retryHandler);
        }
        Optional<ClientProxy> proxy = ClientProxy.proxyFromConfiguration(config);
        proxy.ifPresent(clientProxy -> {
            URI u = clientProxy.uri();
            HttpHost proxyHost = new HttpHost(u.getHost(), u.getPort(), u.getScheme());
            if (clientProxy.userName() != null && clientProxy.password() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(u.getHost(), u.getPort()), new UsernamePasswordCredentials(clientProxy.userName(), clientProxy.password()));
                clientBuilder.setDefaultCredentialsProvider(credsProvider);
            }
            clientBuilder.setProxy(proxyHost);
        });
        Boolean preemptiveBasicAuthProperty = (Boolean)config.getProperties().get("jersey.config.apache.client.preemptiveBasicAuthentication");
        this.preemptiveBasicAuth = preemptiveBasicAuthProperty != null ? preemptiveBasicAuthProperty : false;
        boolean ignoreCookies = PropertiesHelper.isProperty(config.getProperties(), "jersey.config.apache.client.handleCookies");
        if (reqConfig != null) {
            RequestConfig.Builder reqConfigBuilder = RequestConfig.copy((RequestConfig)reqConfig);
            if (ignoreCookies) {
                reqConfigBuilder.setCookieSpec("ignoreCookies");
            }
            this.requestConfig = reqConfigBuilder.build();
        } else {
            if (ignoreCookies) {
                requestConfigBuilder.setCookieSpec("ignoreCookies");
            }
            this.requestConfig = requestConfigBuilder.build();
        }
        if (this.requestConfig.getCookieSpec() == null || !this.requestConfig.getCookieSpec().equals("ignoreCookies")) {
            this.cookieStore = new BasicCookieStore();
            clientBuilder.setDefaultCookieStore(this.cookieStore);
        } else {
            this.cookieStore = null;
        }
        clientBuilder.setDefaultRequestConfig(this.requestConfig);
        LinkedList contracts = config.getInstances().stream().filter(ApacheHttpClientBuilderConfigurator.class::isInstance).collect(Collectors.toCollection(LinkedList::new));
        HttpClientBuilder configuredBuilder = clientBuilder;
        for (Object configurator : contracts) {
            configuredBuilder = ((ApacheHttpClientBuilderConfigurator)configurator).configure(configuredBuilder);
        }
        this.client = configuredBuilder.build();
    }

    private HttpClientConnectionManager getConnectionManager(Client client, Configuration config, SSLContext sslContext, boolean useSystemProperties) {
        Object cmObject = config.getProperties().get("jersey.config.apache.client.connectionManager");
        if (cmObject != null) {
            if (cmObject instanceof HttpClientConnectionManager) {
                return (HttpClientConnectionManager)cmObject;
            }
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.connectionManager", cmObject.getClass().getName(), HttpClientConnectionManager.class.getName()));
        }
        return this.createConnectionManager(client, config, sslContext, useSystemProperties);
    }

    private HttpClientConnectionManager createConnectionManager(Client client, Configuration config, SSLContext sslContext, boolean useSystemProperties) {
        String s2;
        String[] supportedProtocols = useSystemProperties ? ApacheConnector.split(System.getProperty("https.protocols")) : null;
        String[] supportedCipherSuites = useSystemProperties ? ApacheConnector.split(System.getProperty("https.cipherSuites")) : null;
        HostnameVerifier hostnameVerifier = client.getHostnameVerifier();
        SniSSLConnectionSocketFactory sslSocketFactory = sslContext != null ? new SniSSLConnectionSocketFactory(sslContext, supportedProtocols, supportedCipherSuites, hostnameVerifier) : (useSystemProperties ? new SniSSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifier) : new SniSSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier));
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        Integer chunkSize = ClientProperties.getValue(config.getProperties(), "jersey.config.client.chunkedEncodingSize", 4096, Integer.class);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry, new ConnectionFactory(chunkSize));
        if (useSystemProperties && "true".equalsIgnoreCase(s2 = System.getProperty("http.keepAlive", "true"))) {
            s2 = System.getProperty("http.maxConnections", "5");
            int max = Integer.parseInt(s2);
            connectionManager.setDefaultMaxPerRoute(max);
            connectionManager.setMaxTotal(2 * max);
        }
        return connectionManager;
    }

    private static String[] split(String s2) {
        if (TextUtils.isBlank(s2)) {
            return null;
        }
        return s2.split(" *, *");
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    @Override
    public ClientResponse apply(ClientRequest clientRequest) throws ProcessingException {
        HttpUriRequest request = this.getUriHttpRequest(clientRequest);
        Map<String, String> clientHeadersSnapshot = ApacheConnector.writeOutBoundHeaders(clientRequest, request);
        HttpHost httpHost = this.getHost(request);
        try {
            CredentialsProvider credentialsProvider;
            HttpClientContext context = HttpClientContext.create();
            if (this.preemptiveBasicAuth) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicScheme = new BasicScheme();
                authCache.put(httpHost, basicScheme);
                context.setAuthCache(authCache);
            }
            if ((credentialsProvider = (CredentialsProvider)((Object)clientRequest.resolveProperty("jersey.config.apache.client.credentialsProvider", CredentialsProvider.class))) != null) {
                context.setCredentialsProvider(credentialsProvider);
            }
            context.setAttribute(JERSEY_REQUEST_ATTR_NAME, clientRequest);
            CloseableHttpResponse response = this.client.execute(httpHost, (HttpRequest)request, (HttpContext)context);
            HeaderUtils.checkHeaderChanges(clientHeadersSnapshot, clientRequest.getHeaders(), this.getClass().getName(), clientRequest.getConfiguration());
            Response.StatusType status = response.getStatusLine().getReasonPhrase() == null ? Statuses.from(response.getStatusLine().getStatusCode()) : Statuses.from(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            ClientResponse responseContext = new ClientResponse(status, clientRequest);
            List<URI> redirectLocations = context.getRedirectLocations();
            if (redirectLocations != null && !redirectLocations.isEmpty()) {
                responseContext.setResolvedRequestUri(redirectLocations.get(redirectLocations.size() - 1));
            }
            Header[] respHeaders = response.getAllHeaders();
            MultivaluedMap<String, String> headers = responseContext.getHeaders();
            for (Header header : respHeaders) {
                String headerName = header.getName();
                ArrayList<String> list = (ArrayList<String>)headers.get(headerName);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                headers.put(headerName, (String)((Object)list));
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (headers.get("Content-Length") == null && entity.getContentLength() >= 0L) {
                    headers.add("Content-Length", String.valueOf(entity.getContentLength()));
                }
                Header contentEncoding = entity.getContentEncoding();
                if (headers.get("Content-Encoding") == null && contentEncoding != null) {
                    headers.add("Content-Encoding", contentEncoding.getValue());
                }
            }
            try {
                ConnectionClosingMechanism closingMechanism = new ConnectionClosingMechanism(clientRequest, request);
                responseContext.setEntityStream(ApacheConnector.getInputStream(response, closingMechanism, () -> clientRequest.isCancelled()));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, null, e);
            }
            return responseContext;
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    @Override
    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        try {
            ClientResponse response = this.apply(request);
            callback.response(response);
            return CompletableFuture.completedFuture(response);
        }
        catch (Throwable t2) {
            callback.failure(t2);
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(t2);
            return future;
        }
    }

    @Override
    public String getName() {
        return "Apache HttpClient " + release;
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.FAILED_TO_STOP_CLIENT(), e);
        }
    }

    private HttpHost getHost(HttpUriRequest request) {
        return new HttpHost(request.getURI().getHost(), request.getURI().getPort(), request.getURI().getScheme());
    }

    private HttpUriRequest getUriHttpRequest(ClientRequest clientRequest) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.copy(this.requestConfig);
        int connectTimeout = clientRequest.resolveProperty("jersey.config.client.connectTimeout", -1);
        int socketTimeout = clientRequest.resolveProperty("jersey.config.client.readTimeout", -1);
        if (connectTimeout >= 0) {
            requestConfigBuilder.setConnectTimeout(connectTimeout);
        }
        if (socketTimeout >= 0) {
            requestConfigBuilder.setSocketTimeout(socketTimeout);
        }
        Boolean redirectsEnabled = clientRequest.resolveProperty("jersey.config.client.followRedirects", this.requestConfig.isRedirectsEnabled());
        requestConfigBuilder.setRedirectsEnabled(redirectsEnabled);
        Boolean bufferingEnabled = clientRequest.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class) == RequestEntityProcessing.BUFFERED;
        HttpEntity entity = this.getHttpEntity(clientRequest, bufferingEnabled);
        return RequestBuilder.create(clientRequest.getMethod()).setUri(clientRequest.getUri()).setConfig(requestConfigBuilder.build()).setEntity(entity).build();
    }

    private HttpEntity getHttpEntity(final ClientRequest clientRequest, final boolean bufferingEnabled) {
        Object entity = clientRequest.getEntity();
        if (entity == null) {
            return null;
        }
        if (HttpEntity.class.isInstance(entity)) {
            return this.wrapHttpEntity(clientRequest, (HttpEntity)entity);
        }
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(){

            @Override
            public boolean isRepeatable() {
                return false;
            }

            @Override
            public long getContentLength() {
                return -1L;
            }

            @Override
            public InputStream getContent() throws IOException, IllegalStateException {
                if (bufferingEnabled) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
                    this.writeTo(buffer);
                    return new ByteArrayInputStream(buffer.toByteArray());
                }
                return null;
            }

            @Override
            public void writeTo(final OutputStream outputStream) throws IOException {
                clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    @Override
                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return outputStream;
                    }
                });
                clientRequest.writeEntity();
            }

            @Override
            public boolean isStreaming() {
                return false;
            }
        };
        return ApacheConnector.bufferEntity(httpEntity, bufferingEnabled);
    }

    private HttpEntity wrapHttpEntity(final ClientRequest clientRequest, final HttpEntity originalEntity) {
        boolean bufferingEnabled = BufferedHttpEntity.class.isInstance(originalEntity);
        try {
            clientRequest.setEntity(originalEntity.getContent());
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_READING_HTTPENTITY_STREAM(e.getMessage()), e);
        }
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(){

            @Override
            public boolean isRepeatable() {
                return originalEntity.isRepeatable();
            }

            @Override
            public long getContentLength() {
                return originalEntity.getContentLength();
            }

            @Override
            public Header getContentType() {
                return originalEntity.getContentType();
            }

            @Override
            public Header getContentEncoding() {
                return originalEntity.getContentEncoding();
            }

            @Override
            public InputStream getContent() throws IOException, IllegalStateException {
                return originalEntity.getContent();
            }

            @Override
            public void writeTo(final OutputStream outputStream) throws IOException {
                clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    @Override
                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return outputStream;
                    }
                });
                clientRequest.writeEntity();
            }

            @Override
            public boolean isStreaming() {
                return originalEntity.isStreaming();
            }

            @Override
            public boolean isChunked() {
                return originalEntity.isChunked();
            }
        };
        return ApacheConnector.bufferEntity(httpEntity, bufferingEnabled);
    }

    private static HttpEntity bufferEntity(HttpEntity httpEntity, boolean bufferingEnabled) {
        if (bufferingEnabled) {
            try {
                return new BufferedHttpEntity(httpEntity);
            }
            catch (IOException e) {
                throw new ProcessingException(LocalizationMessages.ERROR_BUFFERING_ENTITY(), e);
            }
        }
        return httpEntity;
    }

    private static Map<String, String> writeOutBoundHeaders(ClientRequest clientRequest, HttpUriRequest request) {
        Map<String, String> stringHeaders = HeaderUtils.asStringHeadersSingleValue(clientRequest.getHeaders(), clientRequest.getConfiguration());
        for (Map.Entry<String, String> e : stringHeaders.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return stringHeaders;
    }

    private static InputStream getInputStream(CloseableHttpResponse response, ConnectionClosingMechanism closingMechanism, Supplier<Boolean> isCancelled) throws IOException {
        CancellableInputStream i;
        InputStream inputStream = response.getEntity() == null ? new ByteArrayInputStream(new byte[0]) : (((InputStream)(i = new CancellableInputStream(response.getEntity().getContent(), isCancelled))).markSupported() ? i : (ReaderWriter.AUTOSIZE_BUFFER ? new BufferedInputStream(i) : new BufferedInputStream(i, ReaderWriter.BUFFER_SIZE)));
        return closingMechanism.getEntityStream(inputStream, response);
    }

    private static class CancellableInputStream
    extends InputStreamWrapper {
        private final InputStream in;
        private final Supplier<Boolean> isCancelled;

        private CancellableInputStream(InputStream in, Supplier<Boolean> isCancelled) {
            this.in = in;
            this.isCancelled = isCancelled;
        }

        @Override
        protected InputStream getWrapped() {
            return this.in;
        }

        @Override
        protected InputStream getWrappedIOE() throws IOException {
            if (this.isCancelled.get().booleanValue()) {
                throw new IOException(new CancellationException());
            }
            return this.in;
        }
    }

    private static final class SniSSLConnectionSocketFactory
    extends SSLConnectionSocketFactory {
        private final ThreadLocal<HttpContext> httpContexts = new ThreadLocal();

        public SniSSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
            super(sslContext, supportedProtocols, supportedCipherSuites, hostnameVerifier);
        }

        public SniSSLConnectionSocketFactory(SSLSocketFactory socketFactory, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
            super(socketFactory, supportedProtocols, supportedCipherSuites, hostnameVerifier);
        }

        public SniSSLConnectionSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
            super(sslContext, hostnameVerifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
            this.httpContexts.set(context);
            try {
                Socket socket2 = super.createLayeredSocket(socket, target, port, context);
                return socket2;
            }
            finally {
                this.httpContexts.remove();
            }
        }

        @Override
        protected void prepareSocket(SSLSocket socket) throws IOException {
            Object objectRequest;
            HttpContext context = this.httpContexts.get();
            if (context != null && (objectRequest = context.getAttribute(ApacheConnector.JERSEY_REQUEST_ATTR_NAME)) != null) {
                ClientRequest clientRequest = (ClientRequest)objectRequest;
                SSLParamConfigurator sniConfig = SSLParamConfigurator.builder().request(clientRequest).setSNIHostName(clientRequest).build();
                sniConfig.setSNIServerName(socket);
            }
        }
    }

    private static class HttpClientConnection
    extends DefaultManagedHttpClientConnection {
        private final int chunkSize;

        private HttpClientConnection(String id, int buffersize, int chunkSize) {
            super(id, buffersize);
            this.chunkSize = chunkSize;
        }

        @Override
        protected OutputStream createOutputStream(long len, SessionOutputBuffer outbuffer) {
            if (len == -2L) {
                return new ChunkedOutputStream(this.chunkSize, outbuffer);
            }
            return super.createOutputStream(len, outbuffer);
        }
    }

    private static class ConnectionFactory
    extends ManagedHttpClientConnectionFactory {
        private static final AtomicLong COUNTER = new AtomicLong();
        private final int chunkSize;

        private ConnectionFactory(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Override
        public ManagedHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
            String id = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
            return new HttpClientConnection(id, config.getBufferSize(), this.chunkSize);
        }
    }

    private final class ConnectionClosingMechanism {
        private ApacheConnectionClosingStrategy connectionClosingStrategy = null;
        private final ClientRequest clientRequest;
        private final HttpUriRequest apacheRequest;

        private ConnectionClosingMechanism(ClientRequest clientRequest, HttpUriRequest apacheRequest) {
            this.clientRequest = clientRequest;
            this.apacheRequest = apacheRequest;
            Class<Object> closingStrategyProperty = clientRequest.resolveProperty("jersey.config.apache.client.connectionClosingStrategy", Object.class);
            if (closingStrategyProperty != null) {
                if (ApacheConnectionClosingStrategy.class.isInstance(closingStrategyProperty)) {
                    this.connectionClosingStrategy = (ApacheConnectionClosingStrategy)((Object)closingStrategyProperty);
                } else {
                    LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.connectionClosingStrategy", closingStrategyProperty, ApacheConnectionClosingStrategy.class.getName()));
                }
            }
            if (this.connectionClosingStrategy == null) {
                this.connectionClosingStrategy = vi.getRelease().compareTo("4.5") > 0 ? ApacheConnectionClosingStrategy.GracefulClosingStrategy.INSTANCE : ApacheConnectionClosingStrategy.ImmediateClosingStrategy.INSTANCE;
            }
        }

        private InputStream getEntityStream(InputStream inputStream, final CloseableHttpResponse response) {
            FilterInputStream filterStream = new FilterInputStream(inputStream){

                @Override
                public void close() throws IOException {
                    ConnectionClosingMechanism.this.connectionClosingStrategy.close(ConnectionClosingMechanism.this.clientRequest, ConnectionClosingMechanism.this.apacheRequest, response, this.in);
                }
            };
            return filterStream;
        }
    }
}

