/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.cite.gpkg10.SuiteAttribute;
import org.opengis.cite.gpkg10.TestRunArg;
import org.opengis.cite.gpkg10.util.TestSuiteLogger;
import org.opengis.cite.gpkg10.util.URIUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        this.deleteTempFiles(suite);
    }

    void processSuiteParameters(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        File gpkgFile = null;
        try {
            gpkgFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", gpkgFile.getAbsolutePath(), gpkgFile.length()));
        suite.setAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName(), gpkgFile);
    }

    void deleteTempFiles(ISuite suite) {
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
    }
}

