/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.opengis.cite.gpkg10.ColumnDefinition;
import org.opengis.cite.gpkg10.CommonFixture;
import org.opengis.cite.gpkg10.ErrorMessage;
import org.opengis.cite.gpkg10.TableVerifier;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SpatialReferenceSystemsTests
extends CommonFixture {
    @Test(description="See OGC 12-128r12: Requirement 10")
    public void srsTableDefinition() throws SQLException {
        try {
            HashMap<String, ColumnDefinition> spatialReferenceSystemColumns = new HashMap<String, ColumnDefinition>();
            spatialReferenceSystemColumns.put("srs_name", new ColumnDefinition("TEXT", true, false, false, null));
            spatialReferenceSystemColumns.put("srs_id", new ColumnDefinition("INTEGER", true, true, true, null));
            spatialReferenceSystemColumns.put("organization", new ColumnDefinition("TEXT", true, false, false, null));
            spatialReferenceSystemColumns.put("organization_coordsys_id", new ColumnDefinition("INTEGER", true, false, false, null));
            spatialReferenceSystemColumns.put("definition", new ColumnDefinition("TEXT", true, false, false, null));
            spatialReferenceSystemColumns.put("description", new ColumnDefinition("TEXT", false, false, false, null));
            TableVerifier.verifyTable(this.databaseConnection, "gpkg_spatial_ref_sys", spatialReferenceSystemColumns, Collections.emptySet(), Collections.emptyList());
        }
        catch (Throwable th) {
            AssertJUnit.fail(ErrorMessage.format("BadSrsTableDefinition", th.getMessage()));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 11")
    public void requiredSrsEntries() throws SQLException {
        ResultSet srsDefaultValue;
        try (Statement statement = this.databaseConnection.createStatement();){
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE organization_coordsys_id = 4326 AND (organization = 'EPSG' OR organization = 'epsg');");
            try {
                Assert.assertTrue(srsDefaultValue.next(), ErrorMessage.format("NoGeographicSrs", new Object[0]));
            }
            finally {
                if (srsDefaultValue != null) {
                    srsDefaultValue.close();
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = -1 AND organization = 'NONE' AND organization_coordsys_id = -1 AND definition = 'undefined';");
            try {
                Assert.assertTrue(srsDefaultValue.next(), ErrorMessage.format("NoUndefinedCartesianSrs", new Object[0]));
            }
            finally {
                if (srsDefaultValue != null) {
                    srsDefaultValue.close();
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        statement = this.databaseConnection.createStatement();
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = 0 AND organization = 'NONE' AND organization_coordsys_id =  0 AND definition = 'undefined';");
            try {
                Assert.assertTrue(srsDefaultValue.next(), ErrorMessage.format("NoUndefinedGeographicSrs", new Object[0]));
            }
            finally {
                if (srsDefaultValue != null) {
                    srsDefaultValue.close();
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 12")
    public void checkContentSrs() throws SQLException {
        String query = "SELECT DISTINCT srs_id as srsContents FROM gpkg_contents WHERE srsContents NOT IN (SELECT srs_id FROM gpkg_spatial_ref_sys);";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet srsDefined = statement.executeQuery("SELECT DISTINCT srs_id as srsContents FROM gpkg_contents WHERE srsContents NOT IN (SELECT srs_id FROM gpkg_spatial_ref_sys);");){
            LinkedList<String> invalidSrsIds = new LinkedList<String>();
            while (srsDefined.next()) {
                invalidSrsIds.add(srsDefined.getString("srsContents"));
            }
            Assert.assertTrue(invalidSrsIds.isEmpty(), ErrorMessage.format("UndefinedSrs", invalidSrsIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }
}

