/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.opengis.cite.gpkg10.ReusableEntityFilter;
import org.w3c.dom.Document;

public class ClientUtils {
    private static final Logger LOGGER = Logger.getLogger(ClientUtils.class.getName());

    public static Client buildClient() {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.followRedirects", true);
        config.property("jersey.config.client.connectTimeout", 10000);
        config.register(new LoggingFeature(LOGGER, Level.ALL, LoggingFeature.Verbosity.PAYLOAD_ANY, 5000));
        Client client = ClientBuilder.newClient(config);
        client.register(new ReusableEntityFilter());
        return client;
    }

    public static Client buildClientWithProxy(String proxyHost, int proxyPort) {
        ClientConfig config = new ClientConfig();
        config.connectorProvider(new ApacheConnectorProvider());
        config.register(new LoggingFeature(LOGGER, Level.ALL, LoggingFeature.Verbosity.PAYLOAD_ANY, 5000));
        InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
        config.property("jersey.config.client.proxy.uri", proxy);
        config.property("jersey.config.client.followRedirects", true);
        config.property("jersey.config.client.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
        config.property("jersey.config.client.logging.logger.level", Level.ALL);
        Client client = ClientBuilder.newClient(config);
        client.register(new ReusableEntityFilter());
        return client;
    }

    public static Response buildGetRequest(URI endpoint, Map<String, String> qryParams, MediaType ... mediaTypes) {
        UriBuilder uriBuilder = UriBuilder.fromUri(endpoint);
        if (null != qryParams) {
            for (Map.Entry<String, String> param : qryParams.entrySet()) {
                uriBuilder.queryParam(param.getKey(), param.getValue());
            }
        }
        URI uri = uriBuilder.build(new Object[0]);
        WebTarget target = ClientUtils.buildClient().target(uri);
        Invocation.Builder reqBuilder = target.request();
        if (null != mediaTypes && mediaTypes.length > 0) {
            reqBuilder = reqBuilder.accept(mediaTypes);
        }
        Invocation req = reqBuilder.buildGet();
        return req.invoke();
    }

    public static MediaType removeParameters(MediaType mediaType) {
        return new MediaType(mediaType.getType(), mediaType.getSubtype());
    }

    public static Source getResponseEntityAsSource(Response response, String targetURI) {
        Source source = response.readEntity(DOMSource.class);
        if (null != targetURI && !targetURI.isEmpty()) {
            source.setSystemId(targetURI);
        }
        return source;
    }

    public static Document getResponseEntityAsDocument(Response response, String targetURI) {
        DOMSource domSource = (DOMSource)ClientUtils.getResponseEntityAsSource(response, targetURI);
        Document entityDoc = (Document)domSource.getNode();
        entityDoc.setDocumentURI(domSource.getSystemId());
        return entityDoc;
    }
}

