/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opengis.cite.gpkg10.ColumnDefinition;
import org.opengis.cite.gpkg10.ForeignKeyDefinition;
import org.opengis.cite.gpkg10.UniqueDefinition;

public class TableDefinition {
    private final String name;
    private final Map<String, ColumnDefinition> columns;
    private final Set<ForeignKeyDefinition> foreignKeys;
    private final Set<UniqueDefinition> groupUniques;

    public TableDefinition(String name, Map<String, ColumnDefinition> columns) {
        this(name, columns, Collections.emptySet(), Collections.emptySet());
    }

    public TableDefinition(String name, Map<String, ColumnDefinition> columns, Set<ForeignKeyDefinition> foreignKeys) {
        this(name, columns, foreignKeys, Collections.emptySet());
    }

    public TableDefinition(String name, Map<String, ColumnDefinition> columns, Set<ForeignKeyDefinition> foreignKeys, Set<UniqueDefinition> groupUniques) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Table name may not be null or empty");
        }
        if (columns == null) {
            throw new IllegalArgumentException("Columns name may not be null");
        }
        if (foreignKeys == null) {
            throw new IllegalArgumentException("Foreign key collection may not be null");
        }
        if (groupUniques == null) {
            throw new IllegalArgumentException("Group uniques collection may not be null");
        }
        Set<String> columnNames = columns.keySet();
        Set badForeignKeyFromColumns = foreignKeys.stream().map(foreignKey -> foreignKey.getFromColumnName()).filter(foreignKeyFromColumnName -> !columnNames.contains(foreignKeyFromColumnName)).collect(Collectors.toSet());
        if (badForeignKeyFromColumns.size() > 0) {
            throw new IllegalArgumentException(String.format("Foreign key definitions reference a the following 'from' columns that do not exist in this table: %s", String.join((CharSequence)", ", badForeignKeyFromColumns)));
        }
        Set groupUniqueColumns = groupUniques.stream().collect(HashSet::new, (set, groupUnique) -> set.addAll(groupUnique.getColumnNames()), (set1, set2) -> set1.addAll(set2));
        Set badGroupUniqueColumns = groupUniqueColumns.stream().filter(columnName -> !columnNames.contains(columnName)).collect(Collectors.toSet());
        if (badGroupUniqueColumns.size() > 0) {
            throw new IllegalArgumentException(String.format("Group unique definitions reference the following columns that do not exist in this table: %s", String.join((CharSequence)", ", badGroupUniqueColumns)));
        }
        this.name = name;
        this.columns = columns;
        this.foreignKeys = foreignKeys;
        this.groupUniques = groupUniques;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ColumnDefinition> getColumns() {
        return this.columns;
    }

    public Set<ForeignKeyDefinition> getForeignKeys() {
        return this.foreignKeys;
    }

    protected Set<UniqueDefinition> getGroupUniques() {
        return this.groupUniques;
    }
}

