/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10;

public class ForeignKeyDefinition {
    private final String referenceTableName;
    private final String fromColumnName;
    private final String toColumnName;

    public ForeignKeyDefinition(String referenceTableName, String fromColumnName, String toColumnName) {
        if (referenceTableName == null || referenceTableName.isEmpty()) {
            throw new IllegalArgumentException("Reference table name may not be null or empty");
        }
        if (fromColumnName == null || fromColumnName.isEmpty()) {
            throw new IllegalArgumentException("From column name table name may not be null or empty");
        }
        if (toColumnName == null || toColumnName.isEmpty()) {
            throw new IllegalArgumentException("To column name may not be null or empty");
        }
        this.referenceTableName = referenceTableName;
        this.fromColumnName = fromColumnName;
        this.toColumnName = toColumnName;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ForeignKeyDefinition)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ForeignKeyDefinition other = (ForeignKeyDefinition)object;
        return this.referenceTableName.equals(other.referenceTableName) && this.fromColumnName.equals(other.fromColumnName) && this.toColumnName.equals(other.toColumnName);
    }

    public int hashCode() {
        return this.referenceTableName.hashCode() ^ this.fromColumnName.hashCode() ^ this.toColumnName.hashCode();
    }

    public String getReferenceTableName() {
        return this.referenceTableName;
    }

    public String getFromColumnName() {
        return this.fromColumnName;
    }

    public String getToColumnName() {
        return this.toColumnName;
    }
}

