/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.opengis.cite.gpkg10.ColumnDefinition;
import org.opengis.cite.gpkg10.CommonFixture;
import org.opengis.cite.gpkg10.ErrorMessage;
import org.opengis.cite.gpkg10.ForeignKeyDefinition;
import org.opengis.cite.gpkg10.TableVerifier;
import org.opengis.cite.gpkg10.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class DataContentsTests
extends CommonFixture {
    private static final Pattern TEXT_TYPE = Pattern.compile("TEXT\\([0-9]+\\)");
    private static final Pattern BLOB_TYPE = Pattern.compile("BLOB\\([0-9]+\\)");
    private static final List<String> ALLOWED_SQL_TYPES = Arrays.asList("BOOLEAN", "TINYINT", "SMALLINT", "MEDIUMINT", "INT", "FLOAT", "DOUBLE", "REAL", "TEXT", "BLOB", "DATE", "DATETIME", "GEOMETRY", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION", "INTEGER");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 12-128r12: Requirement 5")
    public void columnDataTypes() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name FROM gpkg_contents;");){
            block20: while (resultSet.next()) {
                String tableName = resultSet.getString("table_name");
                if (!DatabaseUtility.doesTableOrViewExist(this.databaseConnection, tableName)) continue;
                Statement preparedStatement = this.databaseConnection.createStatement();
                try {
                    ResultSet pragmaTableInfo = preparedStatement.executeQuery(String.format("PRAGMA table_info('%s');", tableName));
                    try {
                        while (true) {
                            if (!pragmaTableInfo.next()) continue block20;
                            String dataType = pragmaTableInfo.getString("type");
                            boolean correctDataType = ALLOWED_SQL_TYPES.contains(dataType) || TEXT_TYPE.matcher(dataType).matches() || BLOB_TYPE.matcher(dataType).matches();
                            Assert.assertTrue((boolean)correctDataType, (String)ErrorMessage.format("InvalidDataType", dataType, tableName));
                        }
                    }
                    finally {
                        if (pragmaTableInfo == null) continue;
                        pragmaTableInfo.close();
                    }
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            return;
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 13")
    public void contentsTableDefinition() throws SQLException {
        try {
            HashMap<String, ColumnDefinition> contentColumns = new HashMap<String, ColumnDefinition>();
            contentColumns.put("table_name", new ColumnDefinition("TEXT", true, true, true, null));
            contentColumns.put("data_type", new ColumnDefinition("TEXT", true, false, false, null));
            contentColumns.put("identifier", new ColumnDefinition("TEXT", false, false, true, null));
            contentColumns.put("description", new ColumnDefinition("TEXT", false, false, false, "''"));
            contentColumns.put("last_change", new ColumnDefinition("DATETIME", true, false, false, "strftime('%Y-%m-%dT%H:%M:%fZ', 'now')"));
            contentColumns.put("min_x", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("min_y", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("max_x", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("max_y", new ColumnDefinition("DOUBLE", false, false, false, null));
            contentColumns.put("srs_id", new ColumnDefinition("INTEGER", false, false, false, null));
            TableVerifier.verifyTable(this.databaseConnection, "gpkg_contents", contentColumns, new HashSet<ForeignKeyDefinition>(Arrays.asList(new ForeignKeyDefinition("gpkg_spatial_ref_sys", "srs_id", "srs_id"))), Collections.emptyList());
        }
        catch (AssertionError ex) {
            AssertJUnit.fail((String)ErrorMessage.format("BadContentsTableDefinition", ((Throwable)((Object)ex)).getMessage()));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 14")
    public void contentsTablesExist() throws SQLException {
        String query = "SELECT DISTINCT table_name FROM  gpkg_contents WHERE table_name NOT IN (SELECT name FROM sqlite_master);";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT DISTINCT table_name FROM  gpkg_contents WHERE table_name NOT IN (SELECT name FROM sqlite_master);");){
            LinkedList<String> invalidContentsTableNames = new LinkedList<String>();
            while (resultSet.next()) {
                invalidContentsTableNames.add(resultSet.getString(1));
            }
            Assert.assertTrue((boolean)invalidContentsTableNames.isEmpty(), (String)ErrorMessage.format("ContentTableDoesNotExist", String.join((CharSequence)", ", invalidContentsTableNames)));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 15")
    public void timestampFormat() throws SQLException {
        block16: {
            try (Statement statement = this.databaseConnection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT last_change, table_name FROM gpkg_contents;");
                block12: while (true) {
                    while (resultSet.next()) {
                        String lastChange = resultSet.getString("last_change");
                        try {
                            new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SS'Z'").parse(lastChange);
                            continue block12;
                        }
                        catch (ParseException ignore) {
                            AssertJUnit.fail((String)ErrorMessage.format("BadContentsEntryLastChangeFormat", resultSet.getString("table_name")));
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 16")
    public void srsIdReferencesSrsTable() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA foreign_key_check('gpkg_contents');");){
            Assert.assertTrue((!resultSet.next() ? 1 : 0) != 0, (String)ErrorMessage.format("BadContentsTableSrsForeignKey", new Object[0]));
        }
    }
}

