/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg10;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opengis.cite.gpkg10.ColumnDefinition;
import org.opengis.cite.gpkg10.ForeignKeyDefinition;
import org.opengis.cite.gpkg10.UniqueDefinition;

public final class TableVerifier {
    private TableVerifier() {
    }

    public static void verifyTable(Connection connection, String tableName, Map<String, ColumnDefinition> expectedColumns, Set<ForeignKeyDefinition> expectedForeinKeys, Iterable<UniqueDefinition> expectedGroupUniques) throws SQLException {
        TableVerifier.verifyTableDefinition(connection, tableName);
        Set<UniqueDefinition> uniques = TableVerifier.getUniques(connection, tableName);
        TableVerifier.verifyColumns(connection, tableName, expectedColumns, uniques);
        TableVerifier.verifyForeignKeys(connection, tableName, expectedForeinKeys);
        TableVerifier.verifyGroupUniques(tableName, expectedGroupUniques, uniques);
    }

    private static void verifyTableDefinition(Connection connection, String tableName) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT sql FROM sqlite_master WHERE (type = 'table' OR type = 'view') AND tbl_name = ?;");){
            statement.setString(1, tableName);
            try (ResultSet gpkgContents = statement.executeQuery();){
                if (gpkgContents.getString("sql") == null) {
                    throw new RuntimeException(String.format("The `sql` field must include the %s table SQL Definition.", tableName));
                }
            }
        }
    }

    private static Set<UniqueDefinition> getUniques(Connection connection, String tableName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            HashSet<UniqueDefinition> hashSet;
            block24: {
                ResultSet indices = statement.executeQuery(String.format("PRAGMA index_list(%s);", tableName));
                try {
                    HashSet<UniqueDefinition> uniqueDefinitions = new HashSet<UniqueDefinition>();
                    while (indices.next()) {
                        if (!indices.getBoolean("unique")) continue;
                        String indexName = indices.getString("name");
                        Statement nameStatement = connection.createStatement();
                        try {
                            ResultSet namesSet = nameStatement.executeQuery(String.format("PRAGMA index_info(%s);", indexName));
                            try {
                                ArrayList<String> names = new ArrayList<String>();
                                while (namesSet.next()) {
                                    names.add(namesSet.getString("name"));
                                }
                                uniqueDefinitions.add(new UniqueDefinition(names));
                            }
                            finally {
                                if (namesSet == null) continue;
                                namesSet.close();
                            }
                        }
                        finally {
                            if (nameStatement == null) continue;
                            nameStatement.close();
                        }
                    }
                    hashSet = uniqueDefinitions;
                    if (indices == null) break block24;
                }
                catch (Throwable throwable) {
                    if (indices != null) {
                        try {
                            indices.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                indices.close();
            }
            return hashSet;
        }
    }

    private static void verifyColumns(Connection connection, String tableName, Map<String, ColumnDefinition> requiredColumns, Collection<UniqueDefinition> uniques) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet tableInfo = statement.executeQuery(String.format("PRAGMA table_info(%s);", tableName));){
            TreeMap<String, ColumnDefinition> columns = new TreeMap<String, ColumnDefinition>(String.CASE_INSENSITIVE_ORDER);
            while (tableInfo.next()) {
                String columnName = tableInfo.getString("name");
                columns.put(columnName, new ColumnDefinition(tableInfo.getString("type"), tableInfo.getBoolean("notnull"), tableInfo.getBoolean("pk"), uniques.stream().anyMatch(unique -> unique.equals(columnName)), tableInfo.getString("dflt_value")));
            }
            for (Map.Entry<String, ColumnDefinition> column : requiredColumns.entrySet()) {
                if (!columns.containsKey(column.getKey())) {
                    throw new RuntimeException(String.format("Required column: %s.%s is missing", tableName, column.getKey()));
                }
                ColumnDefinition columnDefinition = (ColumnDefinition)columns.get(column.getKey());
                if (columnDefinition == null || columnDefinition.equals(column.getValue()) && TableVerifier.checkExpressionEquivalence(connection, columnDefinition.getDefaultValue(), column.getValue().getDefaultValue())) continue;
                throw new RuntimeException(String.format("Required column %s is defined as:\n%s\nbut should be:\n%s", column.getKey(), columnDefinition.toString(), column.getValue().toString()));
            }
        }
    }

    private static boolean checkExpressionEquivalence(Connection connection, String expression1, String expression2) throws SQLException {
        if (expression1 == null || expression2 == null) {
            return expression1 == null && expression2 == null;
        }
        try (Statement statement = connection.createStatement();){
            boolean bl;
            block13: {
                String query = String.format("SELECT (%s) = (%s);", expression1, expression2);
                ResultSet results = statement.executeQuery(query);
                try {
                    boolean bl2 = bl = results.next() && results.getBoolean(1);
                    if (results == null) break block13;
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                results.close();
            }
            return bl;
        }
    }

    private static void verifyForeignKeys(Connection connection, String tableName, Set<ForeignKeyDefinition> requiredForeignKeys) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try (ResultSet fkInfo = statement.executeQuery(String.format("PRAGMA foreign_key_list(%s);", tableName));){
                LinkedList<ForeignKeyDefinition> foundForeignKeys = new LinkedList<ForeignKeyDefinition>();
                while (fkInfo.next()) {
                    foundForeignKeys.add(new ForeignKeyDefinition(fkInfo.getString("table"), fkInfo.getString("from"), fkInfo.getString("to")));
                }
                HashSet<ForeignKeyDefinition> missingKeys = new HashSet<ForeignKeyDefinition>(requiredForeignKeys);
                missingKeys.removeAll(foundForeignKeys);
                HashSet extraneousKeys = new HashSet(foundForeignKeys);
                extraneousKeys.removeAll(requiredForeignKeys);
                StringBuilder error = new StringBuilder();
                if (!missingKeys.isEmpty()) {
                    error.append(String.format("The table %s is missing the foreign key constraint(s): \n", tableName));
                    for (ForeignKeyDefinition key : missingKeys) {
                        error.append(String.format("%s.%s -> %s.%s\n", tableName, key.getFromColumnName(), key.getReferenceTableName(), key.getToColumnName()));
                    }
                }
                if (!extraneousKeys.isEmpty()) {
                    error.append(String.format("The table %s has extraneous foreign key constraint(s): \n", tableName));
                    for (ForeignKeyDefinition key : extraneousKeys) {
                        error.append(String.format("%s.%s -> %s.%s\n", tableName, key.getFromColumnName(), key.getReferenceTableName(), key.getToColumnName()));
                    }
                }
                if (error.length() != 0) {
                    throw new RuntimeException(error.toString());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void verifyGroupUniques(String tableName, Iterable<UniqueDefinition> requiredGroupUniques, Collection<UniqueDefinition> uniques) {
        for (UniqueDefinition groupUnique : requiredGroupUniques) {
            if (uniques.contains(groupUnique)) continue;
            throw new RuntimeException(String.format("The table %s is missing the column group unique constraint: (%s)", tableName, String.join((CharSequence)", ", groupUnique.getColumnNames())));
        }
    }
}

